/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.tool;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.tool.Coder;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedValues;
import org.rvpf.base.value.BigRational;
import org.rvpf.base.value.Complex;
import org.rvpf.base.value.Dict;
import org.rvpf.base.value.Rational;
import org.rvpf.base.value.State;
import org.rvpf.base.value.Tuple;

public final class Externalizer {
    static final Map<Class<?>, ValueType> _CLASS_TYPE_MAP = new IdentityHashMap();
    static final Map<Byte, ValueType> _CODE_TYPE_MAP = new HashMap<Byte, ValueType>();
    private static final int _MAX_BYTES_BLOCK = 65534;
    private static final int _MAX_UTF_CHARS = 21845;

    private Externalizer() {
    }

    @Nonnull
    @CheckReturnValue
    public static byte[] externalize(@Nullable Serializable serializable) {
        return Externalizer.externalize(serializable, Optional.empty());
    }

    @Nonnull
    @CheckReturnValue
    public static byte[] externalize(@Nullable Serializable serializable, @Nonnull Optional<Coder> coder) {
        byte[] byteArray;
        if (serializable == null) {
            byteArray = new byte[]{};
        } else {
            try {
                ByteArrayOutputStream bytesStream = new ByteArrayOutputStream();
                Externalizer._write(serializable, bytesStream, coder);
                byteArray = bytesStream.toByteArray();
                bytesStream.close();
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
        return byteArray;
    }

    @CheckReturnValue
    public static ValueType getValueType(@Nonnull byte[] byteArray) {
        return byteArray.length > 0 ? ValueType.get(byteArray[0]) : ValueType.NULL;
    }

    @Nullable
    @CheckReturnValue
    public static Serializable internalize(@Nonnull byte[] byteArray) {
        return Externalizer.internalize(byteArray, Optional.empty());
    }

    @Nullable
    @CheckReturnValue
    public static Serializable internalize(@Nonnull byte[] byteArray, @Nonnull Optional<Coder> coder) {
        Serializable serializable;
        if (byteArray.length == 0) {
            serializable = null;
        } else {
            ByteArrayInputStream bytesStream = new ByteArrayInputStream(byteArray);
            try {
                serializable = Externalizer._read(bytesStream, coder);
                Require.equal(0L, bytesStream.available());
                bytesStream.close();
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            catch (ClassNotFoundException exception) {
                throw new RuntimeException(exception);
            }
        }
        return serializable;
    }

    @Nullable
    @CheckReturnValue
    public static Serializable readSerializable(@Nonnull ObjectInput input) throws IOException {
        Serializable serializable;
        int length = input.readInt();
        if (length > 0) {
            byte[] bytes = new byte[length];
            input.readFully(bytes);
            serializable = Externalizer.internalize(bytes);
        } else {
            serializable = null;
        }
        return serializable;
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<String> readString(@Nonnull ObjectInput input) throws IOException {
        int length = input.readInt();
        if (length < 0) {
            return Optional.empty();
        }
        StringBuilder stringBuilder = new StringBuilder(length);
        while (--length >= 0) {
            stringBuilder.append(input.readChar());
        }
        return Optional.of(stringBuilder.toString());
    }

    public static void writeSerializable(@Nullable Serializable serializable, @Nonnull ObjectOutput output) throws IOException {
        byte[] bytes = Externalizer.externalize(serializable);
        output.writeInt(bytes.length);
        if (bytes.length > 0) {
            output.write(bytes);
        }
    }

    public static void writeString(@Nonnull Optional<String> string, @Nonnull ObjectOutput output) throws IOException {
        if (string.isPresent()) {
            output.writeInt(string.get().length());
            output.writeChars(string.get());
        } else {
            output.writeInt(-1);
        }
    }

    private static Serializable _read(InputStream stream, Optional<Coder> coder) throws IOException, ClassNotFoundException {
        Object serializable;
        int typeCode = stream.read();
        Require.success(typeCode >= 0);
        ValueType type = ValueType.get((byte)typeCode);
        if (type == ValueType.OBJECT) {
            ObjectInputStream objectStream = new ObjectInputStream(stream);
            serializable = (Serializable)objectStream.readObject();
            objectStream.close();
        } else {
            DataInputStream dataStream = new DataInputStream(stream);
            switch (type) {
                case BIG_DECIMAL: {
                    int scale = dataStream.readInt();
                    serializable = new BigDecimal(new BigInteger(Externalizer._readByteArray(dataStream)), scale);
                    break;
                }
                case BIG_INTEGER: {
                    serializable = new BigInteger(Externalizer._readByteArray(dataStream));
                    break;
                }
                case BIG_RATIONAL: {
                    BigInteger numerator = new BigInteger(Externalizer._readByteArray(dataStream));
                    BigInteger denominator = new BigInteger(Externalizer._readByteArray(dataStream));
                    serializable = BigRational.valueOf(numerator, denominator);
                    break;
                }
                case BOOLEAN: {
                    serializable = dataStream.readBoolean();
                    break;
                }
                case BYTE: {
                    serializable = dataStream.readByte();
                    break;
                }
                case BYTE_ARRAY: {
                    serializable = Externalizer._readByteArray(dataStream);
                    break;
                }
                case CHARACTER: {
                    serializable = Character.valueOf(dataStream.readChar());
                    break;
                }
                case TUPLE: {
                    serializable = Externalizer._readCollection(dataStream, coder);
                    break;
                }
                case COMPLEX: {
                    double real = dataStream.readDouble();
                    double imaginary = dataStream.readDouble();
                    serializable = Complex.cartesian(real, imaginary);
                    break;
                }
                case DOUBLE: {
                    serializable = dataStream.readDouble();
                    break;
                }
                case FLOAT: {
                    serializable = Float.valueOf(dataStream.readFloat());
                    break;
                }
                case INTEGER: {
                    serializable = dataStream.readInt();
                    break;
                }
                case LONG: {
                    serializable = dataStream.readLong();
                    break;
                }
                case DICT: {
                    serializable = Externalizer._readMap(dataStream, coder);
                    break;
                }
                case RATIONAL: {
                    long numerator = dataStream.readLong();
                    long denominator = dataStream.readLong();
                    serializable = Rational.valueOf(numerator, denominator);
                    break;
                }
                case SHORT: {
                    serializable = dataStream.readShort();
                    break;
                }
                case STATE: {
                    serializable = State.fromString(Externalizer._readString(dataStream, coder));
                    break;
                }
                case STRING: {
                    serializable = Externalizer._readString(dataStream, coder);
                    break;
                }
                default: {
                    throw new ClassCastException("Unrecognized type code '" + typeCode + "'");
                }
            }
            dataStream.close();
        }
        return serializable;
    }

    private static byte[] _readByteArray(DataInputStream input) throws IOException {
        int length;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        while ((length = input.readShort() & 0xFFFF) != 0) {
            byte[] bytes = new byte[length];
            input.readFully(bytes);
            byteStream.write(bytes, 0, bytes.length);
        }
        return byteStream.toByteArray();
    }

    private static Tuple _readCollection(DataInputStream input, Optional<Coder> coder) throws IOException, ClassNotFoundException {
        int size = input.readInt();
        Tuple tuple = new Tuple(size);
        for (int i = 0; i < size; ++i) {
            tuple.add(Externalizer._read(input, coder));
        }
        tuple.freeze();
        return tuple;
    }

    private static Dict _readMap(DataInputStream input, Optional<Coder> coder) throws IOException, ClassNotFoundException {
        int size = input.readInt();
        Dict dict = new Dict(KeyedValues.hashCapacity(size));
        for (int i = 0; i < size; ++i) {
            String key = Externalizer._readString(input, coder);
            dict.put(key, Externalizer._read(input, coder));
        }
        dict.freeze();
        return dict;
    }

    private static String _readString(DataInputStream input, Optional<Coder> coder) throws IOException {
        String string;
        if (coder.isPresent()) {
            string = coder.get().decode(Externalizer._readByteArray(input));
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            while (!(string = input.readUTF()).isEmpty()) {
                stringBuilder.append(string);
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    private static void _write(Serializable serializable, OutputStream stream, Optional<Coder> coder) throws IOException {
        ValueType type = ValueType.get(serializable);
        stream.write(type.getCode());
        if (type == ValueType.OBJECT) {
            ObjectOutputStream objectStream = new ObjectOutputStream(stream);
            objectStream.writeObject(serializable);
            objectStream.close();
        } else {
            DataOutputStream dataStream = new DataOutputStream(stream);
            switch (type) {
                case BIG_DECIMAL: {
                    dataStream.writeInt(((BigDecimal)serializable).scale());
                    Externalizer._writeByteArray(((BigDecimal)serializable).unscaledValue().toByteArray(), dataStream);
                    break;
                }
                case BIG_INTEGER: {
                    Externalizer._writeByteArray(((BigInteger)serializable).toByteArray(), dataStream);
                    break;
                }
                case BIG_RATIONAL: {
                    Externalizer._writeByteArray(((BigRational)serializable).getNumerator().toByteArray(), dataStream);
                    Externalizer._writeByteArray(((BigRational)serializable).getDenominator().toByteArray(), dataStream);
                    break;
                }
                case BOOLEAN: {
                    dataStream.writeBoolean((Boolean)serializable);
                    break;
                }
                case BYTE: {
                    dataStream.writeByte(((Byte)serializable).byteValue());
                    break;
                }
                case BYTE_ARRAY: {
                    Externalizer._writeByteArray((byte[])serializable, dataStream);
                    break;
                }
                case CHARACTER: {
                    dataStream.writeChar(((Character)serializable).charValue());
                    break;
                }
                case TUPLE: {
                    Externalizer._writeCollection((Collection)((Object)serializable), dataStream, coder);
                    break;
                }
                case COMPLEX: {
                    dataStream.writeDouble(((Complex)serializable).real());
                    dataStream.writeDouble(((Complex)serializable).imaginary());
                    break;
                }
                case DOUBLE: {
                    dataStream.writeDouble((Double)serializable);
                    break;
                }
                case INTEGER: {
                    dataStream.writeInt((Integer)serializable);
                    break;
                }
                case FLOAT: {
                    dataStream.writeFloat(((Float)serializable).floatValue());
                    break;
                }
                case LONG: {
                    dataStream.writeLong((Long)serializable);
                    break;
                }
                case DICT: {
                    Externalizer._writeMap((Map)((Object)serializable), dataStream, coder);
                    break;
                }
                case RATIONAL: {
                    dataStream.writeLong(((Rational)serializable).getNumerator());
                    dataStream.writeLong(((Rational)serializable).getDenominator());
                    break;
                }
                case SHORT: {
                    dataStream.writeShort(((Short)serializable).shortValue());
                    break;
                }
                case STATE: 
                case STRING: {
                    Externalizer._writeString(serializable.toString(), dataStream, coder);
                    break;
                }
                default: {
                    Require.failure();
                }
            }
            dataStream.close();
        }
    }

    private static void _writeByteArray(byte[] bytes, DataOutputStream output) throws IOException {
        int begin = 0;
        while (true) {
            int end;
            if ((end = begin + 65534) > bytes.length) {
                end = bytes.length;
            }
            int length = end - begin;
            output.writeShort(length);
            if (begin == end) break;
            output.write(bytes, begin, length);
            begin = end;
        }
    }

    private static void _writeCollection(Collection<?> collection, DataOutputStream output, Optional<Coder> coder) throws IOException {
        Iterator<?> iterator = collection.iterator();
        int size = collection.size();
        int written = 0;
        output.writeInt(size);
        while (iterator.hasNext()) {
            Externalizer._write((Serializable)iterator.next(), output, coder);
            ++written;
        }
        Require.equal(size, written);
    }

    private static void _writeMap(Map<?, ?> map, DataOutputStream output, Optional<Coder> coder) throws IOException {
        Iterator<Map.Entry<?, ?>> iterator = map.entrySet().iterator();
        int size = map.size();
        int written = 0;
        output.writeInt(size);
        while (iterator.hasNext()) {
            Map.Entry<?, ?> entry = iterator.next();
            Externalizer._writeString(String.valueOf(entry.getKey()), output, coder);
            Externalizer._write((Serializable)entry.getValue(), output, coder);
            ++written;
        }
        Require.equal(size, written);
    }

    private static void _writeString(String string, DataOutputStream output, Optional<Coder> coder) throws IOException {
        if (coder.isPresent()) {
            Externalizer._writeByteArray(Require.notNull(coder.get().encode(string)), output);
        } else {
            int begin = 0;
            while (true) {
                int end;
                if ((end = begin + 21845) > string.length()) {
                    end = string.length();
                }
                output.writeUTF(string.substring(begin, end));
                if (begin == end) break;
                begin = end;
            }
        }
    }

    public static enum ValueType {
        BIG_DECIMAL('D', BigDecimal.class),
        BIG_INTEGER('I', BigInteger.class),
        BIG_RATIONAL('R', BigRational.class),
        BOOLEAN('z', Boolean.class),
        BYTE('b', Byte.class),
        BYTE_ARRAY('a', byte[].class),
        CHARACTER('c', Character.class),
        COMPLEX('x', Complex.class),
        DICT('m', Dict.class),
        DOUBLE('d', Double.class),
        FLOAT('f', Float.class),
        INTEGER('i', Integer.class),
        LONG('j', Long.class),
        NULL('0', null),
        OBJECT('o', null),
        RATIONAL('r', Rational.class),
        SHORT('s', Short.class),
        STATE('q', State.class),
        STRING('t', String.class),
        TUPLE('n', Tuple.class);

        private final byte _code;

        private ValueType(char code, Class<?> typeClass) {
            this._code = (byte)code;
            ValueType previous = _CODE_TYPE_MAP.put(this._code, this);
            Require.equal(null, (Object)previous);
            if (typeClass != null) {
                previous = _CLASS_TYPE_MAP.put(typeClass, this);
                Require.equal(null, (Object)previous);
            }
        }

        @Nonnull
        @CheckReturnValue
        public static ValueType get(byte code) {
            ValueType type = _CODE_TYPE_MAP.get(code);
            return type != null ? type : NULL;
        }

        @Nonnull
        @CheckReturnValue
        public static ValueType get(@Nonnull Object object) {
            ValueType type = _CLASS_TYPE_MAP.get(object.getClass());
            return type != null ? type : OBJECT;
        }

        @Nonnull
        @CheckReturnValue
        public static String setToString(@Nonnull EnumSet<ValueType> valueTypes) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ValueType valueType : valueTypes) {
                stringBuilder.append((char)valueType.getCode());
            }
            return stringBuilder.toString();
        }

        @Nonnull
        @CheckReturnValue
        public static EnumSet<ValueType> stringToSet(@Nonnull String valueTypeCodes) {
            EnumSet<ValueType> valueTypeSet = EnumSet.noneOf(ValueType.class);
            for (char code : valueTypeCodes.toCharArray()) {
                ValueType valueType = ValueType.get((byte)code);
                if (valueType == null) continue;
                valueTypeSet.add(valueType);
            }
            return valueTypeSet;
        }

        @CheckReturnValue
        public byte getCode() {
            return this._code;
        }
    }
}

