/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.tool;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.Require;

@Immutable
public final class Inet {
    public static final String LOCAL_HOST = "127.0.0.1";
    private static final Pattern _ADDRESS_PATTERN = Pattern.compile("(?://)?(.*?)(?::([0-9]++)/?)?");

    private Inet() {
    }

    @CheckReturnValue
    public static int allocateTCPPort() {
        int port;
        Socket socket = new Socket();
        try {
            socket.bind(null);
            port = socket.getLocalPort();
            socket.close();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return port;
    }

    @CheckReturnValue
    public static int allocateUDPPort() {
        int port;
        try {
            DatagramSocket socket = new DatagramSocket(null);
            socket.bind(null);
            port = socket.getLocalPort();
            socket.close();
        }
        catch (IOException exception) {
            throw Require.failure(exception);
        }
        return port;
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<byte[]> getHardwareAddress(@Nonnull String name) {
        NetworkInterface networkInterface;
        InetAddress address;
        try {
            address = name.length() > 0 ? InetAddress.getByName(name) : InetAddress.getLocalHost();
        }
        catch (UnknownHostException exception) {
            return Optional.empty();
        }
        if (address.isLoopbackAddress()) {
            return Optional.empty();
        }
        try {
            networkInterface = NetworkInterface.getByInetAddress(address);
        }
        catch (SocketException exception) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(networkInterface.getHardwareAddress());
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    @Nullable
    @CheckReturnValue
    public static InetAddress getLocalAddress(@Nonnull Optional<String> addressString) {
        InetAddress address;
        try {
            address = InetAddress.getByName(addressString.orElse(null));
        }
        catch (UnknownHostException exception) {
            Logger.getInstance(Inet.class).warn(BaseMessages.UNKNOWN_HOST, addressString.get());
            return null;
        }
        if (!Inet.isOnLocalHost(address)) {
            Logger.getInstance(Inet.class).warn(BaseMessages.HOST_NOT_LOCAL, address);
            return null;
        }
        return address;
    }

    @Nonnull
    @CheckReturnValue
    public static InetAddress getLocalHostAddress() {
        InetAddress localHost;
        try {
            localHost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException exception) {
            localHost = InetAddress.getLoopbackAddress();
        }
        return Require.notNull(localHost);
    }

    @CheckReturnValue
    public static boolean isOnLocalHost(@Nonnull InetAddress address) {
        if (address.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(address) != null;
        }
        catch (SocketException exception) {
            throw new RuntimeException(exception);
        }
    }

    @CheckReturnValue
    public static boolean isOnLocalHost(@Nonnull URI uri) {
        InetAddress address;
        try {
            address = InetAddress.getByName(uri.getHost());
        }
        catch (UnknownHostException exception) {
            return false;
        }
        return Inet.isOnLocalHost(address);
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<InetSocketAddress> socketAddress(@Nonnull String addressString) {
        int port;
        String address;
        Matcher matcher = _ADDRESS_PATTERN.matcher(addressString);
        InetSocketAddress socketAddress = null;
        if (matcher.matches() && (socketAddress = new InetSocketAddress(address = matcher.group(1), port = matcher.group(2) != null ? Integer.parseInt(matcher.group(2)) : 0)).isUnresolved()) {
            socketAddress = null;
        }
        return Optional.ofNullable(socketAddress);
    }

    @Nonnull
    @CheckReturnValue
    public static InetAddress substituteAddress(@Nonnull InetAddress address) {
        if (!address.isLoopbackAddress() && Inet.isOnLocalHost(address)) {
            address = Require.notNull(InetAddress.getLoopbackAddress());
        }
        return address;
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<URI> substituteURI(@Nonnull URI uri) {
        try {
            InetAddress address = InetAddress.getByName(uri.getHost());
            if (!address.isLoopbackAddress() && Inet.isOnLocalHost(address)) {
                return Optional.of(new URI(uri.getScheme(), uri.getUserInfo(), InetAddress.getLoopbackAddress().getHostAddress(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()));
            }
        }
        catch (UnknownHostException exception) {
            return Optional.empty();
        }
        catch (URISyntaxException exception) {
            throw new RuntimeException(exception);
        }
        return Optional.of(uri);
    }
}

