/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.tool;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.tool.Require;
import org.rvpf.base.tool.ValueConverter;

@ThreadSafe
public final class Profiler
implements Runnable {
    public static final int DEFAULT_MARGIN = 13;
    public static final String MARGIN_PROPERTY = "rvpf.profile.margin";
    public static final String SAMPLE_COUNT_PROPERTY = "rvpf.profile.sample.count";
    public static final String SAMPLE_MILLIS_PROPERTY = "rvpf.profile.sample.millis";
    public static final String SAMPLE_PRIORITY_PROPERTY = "rvpf.profile.sample.priority";
    public static final String SNAPSHOT_COUNT_PROPERTY = "rvpf.profile.snapshot.count";
    public static final String SNAPSHOT_DEPTH_PROPERTY = "rvpf.profile.snapshot.depth";
    public static final String SNAPSHOT_MILLIS_PROPERTY = "rvpf.profile.snapshot.millis";
    public static final String SNAPSHOT_PRIORITY_PROPERTY = "rvpf.profile.snapshot.priority";
    public static final String START_MILLIS_PROPERTY = "rvpf.profile.start.millis";
    public static final String STOP_IGNORED_PROPERTY = "rvpf.profile.stop.ignored";
    public static final String THREAD_GROUP_PROPERTY = "rvpf.profile.thread.group";
    public static final String THREAD_STATE_PROPERTY = "rvpf.profile.thread.state";
    private static final String _CLASS_NAME = Profiler.class.getName();
    private static final Logger _LOGGER = Logger.getInstance(Profiler.class);
    private static final PrintWriter _LOGGER_PRINT_WRITER = _LOGGER.getPrintWriter(Logger.LogLevel.DEBUG);
    private static Profiler _instance;
    private static volatile String _margin;
    private static Message _traceElementMessage;
    private static Message _traceThreadMessage;
    private final int _sampleCount;
    private final int _sampleMillis;
    private volatile Thread _samplesThread;
    private final int _snapshotCount;
    private final int _snapshotDepth;
    private final int _snapshotMillis;
    private volatile Thread _snapshotsThread;
    private final int _startMillis = Profiler._getProperty("rvpf.profile.start.millis", -1);
    private final boolean _stopIgnored;
    private final String _threadGroup;
    private final String _threadState;

    private Profiler() {
        int snapshotDepth;
        if (this._startMillis > 0) {
            _LOGGER.info(BaseMessages.START_MILLIS, String.valueOf(this._startMillis));
        }
        this._sampleMillis = Profiler._getProperty(SAMPLE_MILLIS_PROPERTY, -1);
        if (this._sampleMillis > 0) {
            _LOGGER.info(BaseMessages.SAMPLE_MILLIS, String.valueOf(this._sampleMillis));
        }
        this._sampleCount = Profiler._getProperty(SAMPLE_COUNT_PROPERTY, Integer.MAX_VALUE);
        if (this._sampleCount < Integer.MAX_VALUE) {
            _LOGGER.info(BaseMessages.SAMPLE_COUNT, String.valueOf(this._sampleCount));
        }
        this._snapshotMillis = Profiler._getProperty(SNAPSHOT_MILLIS_PROPERTY, -1);
        if (this._snapshotMillis > 0) {
            _LOGGER.info(BaseMessages.SNAPSHOT_MILLIS, String.valueOf(this._snapshotMillis));
        }
        this._snapshotCount = Profiler._getProperty(SNAPSHOT_COUNT_PROPERTY, Integer.MAX_VALUE);
        if (this._snapshotCount < Integer.MAX_VALUE) {
            _LOGGER.info(BaseMessages.SNAPSHOT_COUNT, String.valueOf(this._snapshotCount));
        }
        int n = this._snapshotDepth = (snapshotDepth = Profiler._getProperty(SNAPSHOT_DEPTH_PROPERTY, Integer.MAX_VALUE)) > 0 ? snapshotDepth : Integer.MAX_VALUE;
        if (this._snapshotDepth < Integer.MAX_VALUE) {
            _LOGGER.info(BaseMessages.SNAPSHOT_DEPTH, String.valueOf(this._snapshotDepth));
        }
        this._threadGroup = Profiler._getProperty(THREAD_GROUP_PROPERTY);
        if (this._threadGroup != null) {
            _LOGGER.info(BaseMessages.THREAD_GROUP, this._threadGroup);
        }
        this._threadState = Profiler._getProperty(THREAD_STATE_PROPERTY);
        if (this._threadState != null) {
            _LOGGER.info(BaseMessages.THREAD_STATE, this._threadState);
        }
        this._stopIgnored = Profiler._getProperty(STOP_IGNORED_PROPERTY, false);
        if (this._stopIgnored) {
            _LOGGER.info(BaseMessages.STOP_IGNORED, new Object[0]);
        }
    }

    @Nonnull
    @CheckReturnValue
    public static String margin() {
        String margin = _margin;
        if (margin == null) {
            StringBuilder stringBuilder = new StringBuilder("\n");
            int spacesCount = Profiler._getProperty(MARGIN_PROPERTY, 13);
            while (spacesCount-- > 0) {
                stringBuilder.append(" ");
            }
            _margin = margin = stringBuilder.toString();
        }
        return margin;
    }

    public static synchronized void printStackTrace(@Nonnull Thread thread, @Nonnull StackTraceElement[] stackTrace, @Nonnull Optional<String> skippedName, int stackDepth, @Nonnull PrintWriter printWriter) {
        ThreadGroup group = thread.getThreadGroup();
        StringBuilder stringBuilder = new StringBuilder();
        if (_traceThreadMessage == null) {
            _traceThreadMessage = new Message(BaseMessages.TRACE_THREAD, new Object[0]);
            _traceElementMessage = new Message(BaseMessages.TRACE_ELEMENT, new Object[0]);
        }
        stringBuilder.append(_traceThreadMessage.format(String.valueOf(thread.getId()), thread.getName(), group != null ? group.getName() : null, thread.getState().name(), String.valueOf(thread.getPriority())));
        int startIndex = skippedName.isPresent() ? (thread == Thread.currentThread() ? Math.max(Profiler.stackTraceStartIndex(stackTrace, skippedName.get()), 0) : 0) : 0;
        for (int i = startIndex; i < stackTrace.length; ++i) {
            stringBuilder.append(Profiler.margin());
            if (i - startIndex >= stackDepth) {
                stringBuilder.append(BaseMessages.ELLIPSIS);
                break;
            }
            stringBuilder.append(_traceElementMessage.format(stackTrace[i]));
        }
        printWriter.println(stringBuilder);
    }

    public static synchronized void start() {
        Require.equal(null, _instance);
        if (_LOGGER.isDebugEnabled()) {
            _instance = new Profiler();
            if (_instance._areSamplesEnabled()) {
                Thread samplesThread = new Thread((Runnable)_instance.new _Sampler(), "Sampler");
                samplesThread.setPriority(Profiler._getProperty(SAMPLE_PRIORITY_PROPERTY, 9));
                _instance._setSamplesThread(samplesThread);
            }
            if (_instance._areSnapshotsEnabled() || _instance._areSamplesEnabled()) {
                Thread thread = new Thread((Runnable)_instance, "Profiler");
                thread.setPriority(Profiler._getProperty(SNAPSHOT_PRIORITY_PROPERTY, 8));
                _instance._setSnapshotsThread(thread);
                _instance._getSnapshotsThread().start();
            }
        }
    }

    public static synchronized void stop() {
        if (_instance != null && !_instance._isStopIgnored()) {
            try {
                Thread samplesThread;
                Thread thread = _instance._getSnapshotsThread();
                if (thread != null) {
                    thread.interrupt();
                    thread.join();
                }
                if ((samplesThread = _instance._getSamplesThread()) != null) {
                    samplesThread.interrupt();
                    samplesThread.join();
                }
            }
            catch (InterruptedException exception) {
                throw new RuntimeException(exception);
            }
            finally {
                _instance._setSnapshotsThread(null);
                _instance._setSamplesThread(null);
                _instance = null;
            }
        }
    }

    @Override
    public void run() {
        block10: {
            try {
                if (this._startMillis > 0) {
                    Thread.sleep(this._startMillis);
                    if (this._snapshotCount > 0 && this._snapshotMillis <= 0) {
                        _LOGGER.info(BaseMessages.SINGLE_SNAPSHOT, new Object[0]);
                        Profiler._printStackTraces(_LOGGER_PRINT_WRITER, this._getGroup(), this._getThreadState(), this._snapshotDepth, this);
                    }
                }
                if (this._areSamplesEnabled()) {
                    this._samplesThread.start();
                }
                if (this._snapshotMillis <= 0 || this._snapshotCount <= 0) break block10;
                int snapshotCount = this._snapshotCount;
                _LOGGER.info(BaseMessages.STARTING_SNAPSHOTS, new Object[0]);
                try {
                    while (true) {
                        Profiler._printStackTraces(_LOGGER_PRINT_WRITER, this._getGroup(), this._getThreadState(), this._snapshotDepth, this);
                        if (--snapshotCount <= 0) {
                            break;
                        }
                        Thread.sleep(this._snapshotMillis);
                    }
                }
                finally {
                    _LOGGER.info(BaseMessages.STOPPED_SNAPSHOTS, new Object[0]);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Nonnull
    @CheckReturnValue
    static Logger _getLogger() {
        return _LOGGER;
    }

    @CheckReturnValue
    static int stackTraceStartIndex(@Nonnull StackTraceElement[] stackTrace, @Nonnull String skippedName) {
        boolean nameSeen = false;
        for (int i = 0; i < stackTrace.length; ++i) {
            if (skippedName.equals(stackTrace[i].getClassName())) {
                nameSeen = true;
                continue;
            }
            if (!nameSeen) continue;
            return i;
        }
        return -1;
    }

    String _getGroup() {
        return this._threadGroup;
    }

    int _getSampleCount() {
        return this._sampleCount;
    }

    int _getSampleMillis() {
        return this._sampleMillis;
    }

    Thread _getSamplesThread() {
        return this._samplesThread;
    }

    Thread _getSnapshotsThread() {
        return this._snapshotsThread;
    }

    String _getThreadState() {
        return this._threadState;
    }

    private static String _getProperty(String key) {
        return System.getProperty(key);
    }

    private static boolean _getProperty(String key, boolean defaultValue) {
        String value = Profiler._getProperty(key);
        if (value != null) {
            if ((value = value.trim()).isEmpty()) {
                return true;
            }
            if (ValueConverter.isTrue(value)) {
                return true;
            }
            if (ValueConverter.isFalse(value)) {
                return false;
            }
        }
        return defaultValue;
    }

    private static int _getProperty(String key, int defaultValue) {
        String value = Profiler._getProperty(key);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _printStackTraces(PrintWriter printWriter, String threadGroup, String threadState, int stackDepth, Profiler profiler) {
        Class<Profiler> clazz = Profiler.class;
        synchronized (Profiler.class) {
            Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
            // ** MonitorExit[clazz] (shouldn't be in output)
            for (Map.Entry entry : stackTraces.entrySet()) {
                ThreadGroup group;
                Thread thread = (Thread)entry.getKey();
                if (profiler != null && (thread == profiler._getSnapshotsThread() || thread == profiler._getSamplesThread()) || (group = thread.getThreadGroup()) == null || threadGroup != null && !threadGroup.equalsIgnoreCase(group.getName()) || threadState != null && !threadState.equalsIgnoreCase(thread.getState().name())) continue;
                Profiler.printStackTrace(thread, (StackTraceElement[])entry.getValue(), Optional.of(_CLASS_NAME), stackDepth, printWriter);
            }
            return;
        }
    }

    private boolean _areSamplesEnabled() {
        return this._sampleCount > 0 && this._sampleMillis > 0;
    }

    private boolean _areSnapshotsEnabled() {
        return this._snapshotCount > 0 && (this._snapshotMillis > 0 || this._startMillis > 0);
    }

    private boolean _isStopIgnored() {
        return this._stopIgnored;
    }

    private void _setSamplesThread(Thread thread) {
        this._samplesThread = thread;
    }

    private void _setSnapshotsThread(Thread thread) {
        this._snapshotsThread = thread;
    }

    private class _Sampler
    implements Runnable {
        private final Map<Thread, Map<StackTraceElement, _Counter>> _traces = new LinkedHashMap<Thread, Map<StackTraceElement, _Counter>>();

        _Sampler() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void _dump() {
            Message threadMessage = new Message(BaseMessages.THREAD_SAMPLES, new Object[0]);
            Message traceMessage = new Message(BaseMessages.SAMPLE_AT, new Object[0]);
            Comparator<Map.Entry<StackTraceElement, _Counter>> traceElementComparator = new Comparator<Map.Entry<StackTraceElement, _Counter>>(){

                @Override
                public int compare(Map.Entry<StackTraceElement, _Counter> left, Map.Entry<StackTraceElement, _Counter> right) {
                    int comparison = right.getValue().getCount() - left.getValue().getCount();
                    if (comparison == 0) {
                        comparison = left.getValue().getOrder() - right.getValue().getOrder();
                    }
                    return comparison;
                }
            };
            for (Map.Entry<Thread, Map<StackTraceElement, _Counter>> threadTraces : this._traces.entrySet()) {
                Thread thread = threadTraces.getKey();
                String threadMessageText = threadMessage.format(String.valueOf(thread.getId()), thread.getName());
                ArrayList<Map.Entry<StackTraceElement, _Counter>> traces = new ArrayList<Map.Entry<StackTraceElement, _Counter>>(threadTraces.getValue().entrySet());
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(threadMessageText);
                traces.sort(traceElementComparator);
                for (Map.Entry entry : traces) {
                    String traceMessageText = traceMessage.format(entry.getKey(), String.valueOf(((_Counter)entry.getValue()).getCount()));
                    stringBuilder.append(Profiler.margin());
                    stringBuilder.append(traceMessageText);
                }
                Profiler._getLogger().debug(BaseMessages.VERBATIM, stringBuilder);
            }
        }
    }

    private static class _Counter {
        private int _count = 1;
        private final int _order;

        _Counter(int position) {
            this._order = position;
        }

        int getCount() {
            return this._count;
        }

        int getOrder() {
            return this._order;
        }

        void increment() {
            ++this._count;
        }
    }
}

