/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.tool;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Require {
    private Require() {
    }

    @SafeVarargs
    public static <T> void content(@Nonnull Iterable<T> iterable, T ... content) {
        if (!Require._content(iterable, content)) {
            throw new FailureException();
        }
    }

    @SafeVarargs
    public static <T> void content(@Nonnull Iterable<T> iterable, @Nonnull String explanation, T ... content) {
        if (!Require._content(iterable, content)) {
            throw new FailureException((Object)explanation);
        }
    }

    public static void equal(boolean reference, boolean value) {
        if (value != reference) {
            throw new FailureException();
        }
    }

    public static void equal(double reference, double value) {
        if (value != reference) {
            throw new FailureException();
        }
    }

    public static void equal(long reference, long value) {
        if (value != reference) {
            throw new FailureException();
        }
    }

    public static void equal(@Nullable Object reference, @Nullable Object value) {
        if (!Objects.equals(value, reference)) {
            throw new FailureException();
        }
    }

    public static void equal(boolean reference, boolean value, @Nonnull Object explanation) {
        if (value != reference) {
            throw new FailureException(explanation);
        }
    }

    public static void equal(double reference, double value, double sample) {
        if (!Require._equal(reference, value, sample)) {
            throw new FailureException();
        }
    }

    public static void equal(double reference, double value, @Nonnull Object explanation) {
        if (value != reference) {
            throw new FailureException(explanation);
        }
    }

    public static void equal(long reference, long value, @Nonnull Object explanation) {
        if (value != reference) {
            throw new FailureException(explanation);
        }
    }

    public static void equal(@Nullable Object reference, @Nullable Object value, @Nonnull Object explanation) {
        if (!Objects.equals(value, reference)) {
            throw new FailureException(explanation);
        }
    }

    public static void equal(double reference, double value, double sample, @Nonnull Object explanation) {
        if (!Require._equal(reference, value, sample)) {
            throw new FailureException(explanation);
        }
    }

    public static FailureException failure() throws FailureException {
        throw new FailureException();
    }

    public static void failure(boolean value) {
        if (value) {
            throw new FailureException();
        }
    }

    public static FailureException failure(@Nonnull Exception cause) throws FailureException {
        throw new FailureException((Object)Require.notNull(cause));
    }

    public static FailureException failure(@Nonnull Object explanation) throws FailureException {
        throw new FailureException(explanation);
    }

    public static void failure(boolean value, @Nonnull Object explanation) {
        if (value) {
            throw new FailureException(explanation);
        }
    }

    public static FailureException failure(@Nonnull Exception cause, @Nonnull Object explanation) throws FailureException {
        throw new FailureException(explanation, Require.notNull(cause));
    }

    public static void ignored(boolean value) {
    }

    public static void ignored(double value) {
    }

    public static void ignored(long value) {
    }

    public static void ignored(Object value) {
    }

    @Nonnull
    public static String notEmpty(@Nullable String string) throws FailureException {
        if (string == null || string.length() == 0) {
            throw new FailureException();
        }
        return string;
    }

    @Nonnull
    @CheckReturnValue
    public static String notEmptyTrimmed(@Nullable String string) throws FailureException {
        if (string == null) {
            throw new FailureException();
        }
        if ((string = string.trim()).length() == 0) {
            throw new FailureException();
        }
        return string;
    }

    @Nonnull
    public static <T> T notNull(@Nullable T object) throws FailureException {
        if (object == null) {
            throw new FailureException();
        }
        return object;
    }

    @Nonnull
    public static <T> T notNull(@Nullable T object, @Nonnull Object explanation) throws FailureException {
        if (object == null) {
            throw new FailureException(explanation);
        }
        return object;
    }

    @Nonnull
    public static <T> void notPresent(@Nonnull Optional<T> object) throws FailureException {
        if (object.isPresent()) {
            throw new FailureException();
        }
    }

    @Nonnull
    public static <T> void notPresent(@Nonnull Optional<T> object, @Nonnull Object explanation) throws FailureException {
        if (object.isPresent()) {
            throw new FailureException(explanation);
        }
    }

    @Nonnull
    public static <T> void present(@Nonnull Optional<T> object) throws FailureException {
        if (!object.isPresent()) {
            throw new FailureException();
        }
    }

    @Nonnull
    public static <T> void present(@Nonnull Optional<T> object, @Nonnull Object explanation) throws FailureException {
        if (!object.isPresent()) {
            throw new FailureException(explanation);
        }
    }

    public static void same(@Nullable Object reference, @Nullable Object value) {
        if (reference != value) {
            throw new FailureException();
        }
    }

    public static void same(@Nullable Object reference, @Nullable Object value, @Nonnull Object explanation) {
        if (value != reference) {
            throw new FailureException(explanation);
        }
    }

    public static boolean success(boolean value) {
        if (!value) {
            throw new FailureException();
        }
        return true;
    }

    public static void success(@Nullable Exception exception) {
        if (exception != null) {
            throw new FailureException((Object)exception);
        }
    }

    public static boolean success(boolean value, @Nonnull Object explanation) {
        if (!value) {
            throw new FailureException(explanation);
        }
        return true;
    }

    public static void success(@Nullable Exception exception, @Nonnull Object explanation) {
        if (exception != null) {
            throw new FailureException(explanation, exception);
        }
    }

    @SafeVarargs
    private static <T> boolean _content(Iterable<T> iterable, T ... content) {
        int contentLength = content.length;
        int index = 0;
        for (T value : iterable) {
            if (index < contentLength && Objects.equals(value, content[index++])) continue;
            return false;
        }
        return index == contentLength;
    }

    private static boolean _equal(double reference, double value, double sample) {
        return Math.abs(reference - value) <= Math.ulp(sample);
    }

    public static class FailureException
    extends AssertionError {
        private static final long serialVersionUID = 1L;

        public FailureException() {
        }

        public FailureException(@Nonnull Object cause) {
            super(cause);
        }

        public FailureException(@Nonnull Object text, @Nonnull Exception cause) {
            super(text.toString(), cause);
        }
    }
}

