/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.tool;

import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.IdentityHashSet;

@ThreadSafe
public class TimeoutMonitor
implements Runnable {
    private static final Client[] _EMPTY_CLIENT_ARRAY = new Client[0];
    private static ScheduledThreadPoolExecutor _executor;
    private Client _client;
    private Set<Client> _clients;
    private ScheduledFuture<?> _future;
    private final ElapsedTime _timeout;

    public TimeoutMonitor(@Nonnull ElapsedTime timeout) {
        this._timeout = timeout;
    }

    public static synchronized boolean shutdown() {
        if (_executor != null) {
            if (_executor.getQueue().isEmpty()) {
                _executor.shutdown();
                _executor = null;
            } else {
                return false;
            }
        }
        return true;
    }

    public synchronized void addClient(@Nonnull Client client) {
        if (this._clients == null) {
            Require.equal(null, this._client);
            this._clients = new IdentityHashSet<Client>();
        }
        this._clients.add(client);
        this._activate();
    }

    public synchronized void clearClient() {
        Require.equal(null, this._clients);
        this._deactivate();
        this._client = null;
    }

    public synchronized void removeClient(@Nonnull Client client) {
        if (this._clients != null) {
            this._clients.remove(client);
            if (this._clients.isEmpty()) {
                this._deactivate();
            }
        } else {
            Require.equal(null, this._client);
        }
    }

    @Override
    public synchronized void run() {
        if (this._client != null) {
            this._client.onTimeoutMonitoring();
        } else if (this._clients != null) {
            for (Client client : this._clients.toArray(_EMPTY_CLIENT_ARRAY)) {
                client.onTimeoutMonitoring();
            }
        }
    }

    public synchronized void setClient(@Nonnull Client client) {
        Require.equal(null, this._clients);
        this._deactivate();
        this._client = Require.notNull(client);
        this._activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _activate() {
        if (this._future == null) {
            TimeoutMonitor timeoutMonitor = this;
            synchronized (timeoutMonitor) {
                if (_executor == null) {
                    _executor = new ScheduledThreadPoolExecutor(1);
                    _executor.setKeepAliveTime(1L, TimeUnit.MINUTES);
                    _executor.allowCoreThreadTimeOut(true);
                    _executor.setRemoveOnCancelPolicy(true);
                }
            }
            this._future = _executor.schedule(this, this._timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private void _deactivate() {
        if (this._future != null) {
            this._future.cancel(false);
            this._future = null;
        }
    }

    public static interface Client {
        public void onTimeoutMonitoring();
    }
}

