/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.tool;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPOutputStream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.DateTime;
import org.rvpf.base.UUID;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.Coder;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.util.container.Listeners;

@ThreadSafe
public final class Traces {
    public static final String COMPRESSED_PROPERTY = "compressed";
    public static final String COMPRESSED_SUFFIX_PROPERTY = "compressed.suffix";
    public static final String DEFAULT_COMPRESSED_SUFFIX = ".gz";
    public static final String DEFAULT_PREFIX = "";
    public static final String DEFAULT_ROOT = "traces";
    public static final String DEFAULT_SUFFIX = ".txt";
    public static final String DIR_PROPERTY = "dir";
    public static final String DISABLED_PROPERTY = "disabled";
    public static final String PREFIX_PROPERTY = "prefix";
    public static final String ROOT_PROPERTY = "root";
    public static final String SUFFIX_PROPERTY = "suffix";
    public static final String TRACES_PROPERTIES = "traces";
    private static final Logger _LOGGER = Logger.getInstance(Traces.class);
    private final Coder _coder = new Coder();
    private boolean _compressed;
    private File _directory;
    private final AtomicBoolean _enabled = new AtomicBoolean();
    private final Queue<_Entry> _entries = new ConcurrentLinkedQueue<_Entry>();
    private final Listeners<Listener> _listeners = new Listeners();
    @GuardedBy(value="this")
    private DateTime _midnight;
    @GuardedBy(value="this")
    private OutputStream _outputStream;
    private String _prefix;
    private String _suffix;

    public void add(@Nonnull Object value) {
        this.add(Optional.empty(), value);
    }

    public void add(@Nonnull Optional<String> classifier, @Nonnull Object value) {
        if (this.isEnabled()) {
            if (!this._listeners.isEmpty()) {
                for (Listener listener : this._listeners) {
                    if (listener.onAddTrace(classifier, value, this)) continue;
                    return;
                }
            }
            this._entries.add(new _Entry(classifier, String.valueOf(value)));
        }
    }

    @CheckReturnValue
    public boolean addListener(@Nonnull Listener listener) {
        return this._listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        if (!this.isEnabled() || this._entries.isEmpty()) {
            return;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Traces traces = this;
            synchronized (traces) {
                _Entry entry;
                while ((entry = this._entries.poll()) != null) {
                    DateTime midnight = entry.getStamp().midnight();
                    if (this._midnight == null || !this._midnight.equals(midnight)) {
                        if (this._outputStream != null) {
                            if (stringBuilder.length() > 0) {
                                this._write(stringBuilder);
                                stringBuilder.setLength(0);
                            }
                            this._outputStream.close();
                            this._outputStream = null;
                        }
                        File outputFile = new File(this._directory, this._prefix + midnight.toString().substring(0, 10) + this._suffix);
                        this._outputStream = new FileOutputStream(outputFile, true);
                        this._midnight = midnight;
                    }
                    stringBuilder.append(entry.getStamp().toFullString());
                    stringBuilder.append(" ");
                    Optional<String> entryClassifier = entry.getClassifier();
                    if (entryClassifier.isPresent()) {
                        stringBuilder.append("(");
                        stringBuilder.append(entryClassifier.get());
                        stringBuilder.append(") ");
                    }
                    stringBuilder.append(entry.getValue());
                    stringBuilder.append("\n");
                }
                if (stringBuilder.length() > 0) {
                    this._write(stringBuilder);
                }
            }
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        for (Listener listener : this._listeners) {
            listener.onCommitTraces(this);
        }
    }

    @CheckReturnValue
    public boolean isEnabled() {
        return this._enabled.get();
    }

    @CheckReturnValue
    public boolean removeListener(@Nonnull Listener listener) {
        return this._listeners.remove(listener);
    }

    public void rollback() {
        if (this.isEnabled()) {
            for (Listener listener : this._listeners) {
                listener.onRollbackTraces(this);
            }
            this._entries.clear();
        }
    }

    public void setCompressed(boolean compressed) {
        this._compressed = compressed;
        if (this._compressed) {
            this._suffix = ".txt.gz";
        }
    }

    public void setPrefix(@Nonnull String prefix) {
        this._prefix = prefix;
    }

    public void setSuffix(@Nonnull String suffix) {
        this._suffix = suffix;
    }

    @CheckReturnValue
    public boolean setUp(@Nonnull File where, @Nonnull KeyedGroups how, @Nonnull UUID who, @Nonnull Optional<String> what) {
        Optional<String> dirName;
        Require.notNull(who);
        if (what.isPresent() && (what = Optional.of(what.get().trim())).get().isEmpty()) {
            what = Optional.empty();
        }
        this._enabled.set(what.isPresent() && !how.isMissing() && !how.getBoolean(DISABLED_PROPERTY));
        if (!this.isEnabled()) {
            return true;
        }
        File rootDirectory = new File(where, how.getString(ROOT_PROPERTY, Optional.of("traces")).get());
        File baseDirectory = new File(rootDirectory, (dirName = how.getString(DIR_PROPERTY)).orElse(who.toName()));
        if (baseDirectory.mkdirs()) {
            _LOGGER.debug(BaseMessages.TRACES_BASE_CREATED, baseDirectory.getAbsolutePath());
        } else if (!baseDirectory.isDirectory()) {
            _LOGGER.warn(BaseMessages.TRACES_BASE_FAILED, baseDirectory.getAbsolutePath());
            return false;
        }
        if (!this._setDirectory(new File(baseDirectory, what.get()))) {
            return false;
        }
        this._prefix = how.getString(PREFIX_PROPERTY, Optional.of(DEFAULT_PREFIX)).get();
        this._suffix = how.getString(SUFFIX_PROPERTY, Optional.of(DEFAULT_SUFFIX)).get();
        this._compressed = how.getBoolean(COMPRESSED_PROPERTY, false);
        if (this._compressed) {
            this._suffix = how.getString(COMPRESSED_SUFFIX_PROPERTY, Optional.of(this._suffix + DEFAULT_COMPRESSED_SUFFIX)).get();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() {
        if (this._enabled.compareAndSet(true, false)) {
            this.rollback();
            Traces traces = this;
            synchronized (traces) {
                if (this._outputStream != null) {
                    try {
                        this._outputStream.close();
                    }
                    catch (IOException exception) {
                        throw new RuntimeException(exception);
                    }
                    this._outputStream = null;
                }
                this._midnight = null;
            }
            this._directory = null;
        }
    }

    private boolean _setDirectory(File directory) {
        this._directory = directory;
        if (this._directory.mkdirs()) {
            _LOGGER.debug(BaseMessages.TRACES_DIR_CREATED, this._directory.getAbsolutePath());
        } else if (!this._directory.isDirectory()) {
            _LOGGER.warn(BaseMessages.TRACES_DIR_FAILED, this._directory.getAbsolutePath());
            return false;
        }
        return true;
    }

    private void _write(StringBuilder builder) throws IOException {
        byte[] bytes = this._coder.encode(builder.toString());
        if (this._compressed) {
            GZIPOutputStream compressedStream = new GZIPOutputStream(this._outputStream);
            compressedStream.write(bytes);
            compressedStream.finish();
        } else {
            this._outputStream.write(bytes);
        }
        this._outputStream.flush();
    }

    private static final class _Entry {
        private final Optional<String> _classifier;
        private final DateTime _stamp = DateTime.now();
        private final String _value;

        _Entry(@Nonnull Optional<String> classifier, @Nonnull String value) {
            this._classifier = classifier;
            this._value = value;
        }

        @Nonnull
        @CheckReturnValue
        Optional<String> getClassifier() {
            return this._classifier;
        }

        @Nonnull
        @CheckReturnValue
        DateTime getStamp() {
            return this._stamp;
        }

        @Nonnull
        @CheckReturnValue
        String getValue() {
            return this._value;
        }
    }

    @NotThreadSafe
    public static final class Context
    extends KeyedGroups {
        private static final long serialVersionUID = 1L;

        public Context() {
            super(BaseMessages.VALUE_TYPE.toString(), Optional.empty());
        }

        private Context(Context other) {
            super(other);
        }

        @Override
        public Context copy() {
            return new Context(this);
        }

        @Override
        public Context freeze() {
            super.freeze();
            return this;
        }

        public void setCompressed(boolean compressed) {
            this.setValue(Traces.COMPRESSED_PROPERTY, compressed);
        }

        public void setCompressedSuffix(@Nonnull String suffix) {
            this.setValue(Traces.COMPRESSED_SUFFIX_PROPERTY, suffix);
        }

        public void setDir(@Nonnull String dir) {
            this.setValue(Traces.DIR_PROPERTY, dir);
        }

        public void setDisabled(boolean disabled) {
            this.setValue(Traces.DISABLED_PROPERTY, disabled);
        }

        public void setPrefix(@Nonnull String prefix) {
            this.setValue(Traces.PREFIX_PROPERTY, prefix);
        }

        public void setRoot(@Nonnull String root) {
            this.setValue(Traces.ROOT_PROPERTY, root);
        }

        public void setSuffix(@Nonnull String suffix) {
            this.setValue(Traces.SUFFIX_PROPERTY, suffix);
        }
    }

    public static interface Listener {
        @CheckReturnValue
        public boolean onAddTrace(@Nonnull Optional<String> var1, Object var2, Traces var3);

        public void onCommitTraces(Traces var1);

        public void onRollbackTraces(Traces var1);
    }
}

