/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.tool;

import java.io.File;
import java.io.IOException;
import java.text.Normalizer;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Logger;

@Immutable
public final class ValueConverter {
    public static final int ONE_MEBIBYTE = 0x100000;
    private static final Pattern _FALSE_PATTERN = Pattern.compile("0|FALSE|NO|OFF|F|N", 2);
    private static final Pattern _FIELDS_SPLIT_PATTERN = Pattern.compile("(?:\\s*,\\s*)|\\s+");
    private static final Logger _LOGGER = Logger.getInstance(ValueConverter.class);
    private static final Pattern _TRUE_PATTERN = Pattern.compile("1|TRUE|YES|ON|T|Y", 2);

    private ValueConverter() {
    }

    @Nonnull
    @CheckReturnValue
    public static String canonicalizePath(@Nonnull String path) throws IOException {
        path = new File(path).getCanonicalPath().replace('\\', '/');
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            path = path.replace('\\', '/');
        }
        return path;
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<String> canonicalizeString(@Nonnull Optional<String> text) {
        if (text.isPresent()) {
            return Optional.of(Normalizer.normalize(text.get(), Normalizer.Form.NFC));
        }
        return Optional.empty();
    }

    @CheckReturnValue
    public static boolean convertToBoolean(@Nonnull String type, @Nonnull String name, @Nonnull Optional<String> valueToConvert, boolean defaultValue) {
        return ValueConverter.convertToBoolean(type, name, valueToConvert, Optional.of(defaultValue)).get();
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<Boolean> convertToBoolean(@Nonnull String type, @Nonnull String name, @Nonnull Optional<String> valueToConvert, @Nonnull Optional<Boolean> defaultValue) {
        Optional<Boolean> booleanValue;
        if (valueToConvert.isPresent()) {
            String value = valueToConvert.get().trim();
            if (value.isEmpty()) {
                booleanValue = Optional.of(Boolean.TRUE);
            } else if (ValueConverter.isTrue(value)) {
                booleanValue = Optional.of(Boolean.TRUE);
            } else if (ValueConverter.isFalse(value)) {
                booleanValue = Optional.of(Boolean.FALSE);
            } else {
                _LOGGER.warn(BaseMessages.CONVERT_BOOLEAN, type, name, value, defaultValue.orElse(null));
                booleanValue = defaultValue;
            }
        } else {
            booleanValue = defaultValue;
        }
        return booleanValue;
    }

    @CheckReturnValue
    public static double convertToDouble(@Nonnull String type, @Nonnull String name, @Nonnull Optional<String> valueToConvert, double defaultValue) {
        return ValueConverter.convertToDouble(type, name, valueToConvert, Optional.of(defaultValue)).get();
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<Double> convertToDouble(@Nonnull String type, @Nonnull String name, @Nonnull Optional<String> valueToConvert, @Nonnull Optional<Double> defaultValue) {
        Optional<Double> doubleValue;
        if (valueToConvert.isPresent()) {
            String value = valueToConvert.get().trim();
            if (value.length() > 0) {
                try {
                    doubleValue = Optional.of(Double.valueOf(value));
                }
                catch (NumberFormatException exception) {
                    _LOGGER.warn(BaseMessages.CONVERT_DOUBLE, type, name, value, String.valueOf(defaultValue.orElse(null)));
                    doubleValue = defaultValue;
                }
            } else {
                doubleValue = defaultValue;
            }
        } else {
            doubleValue = defaultValue;
        }
        return doubleValue;
    }

    @CheckReturnValue
    public static int convertToInt(@Nonnull String type, @Nonnull String name, @Nonnull Optional<String> valueToConvert, int defaultValue) {
        return ValueConverter.convertToInteger(type, name, valueToConvert, Optional.of(defaultValue)).get();
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<Integer> convertToInteger(@Nonnull String type, @Nonnull String name, @Nonnull Optional<String> valueToConvert, @Nonnull Optional<Integer> defaultValue) {
        Optional<Integer> integerValue;
        if (valueToConvert.isPresent()) {
            String value = valueToConvert.get().trim();
            if (value.length() > 0) {
                try {
                    integerValue = Optional.of(Integer.decode(value));
                }
                catch (NumberFormatException exception) {
                    _LOGGER.warn(BaseMessages.CONVERT_INTEGER, type, name, value, String.valueOf(defaultValue.orElse(null)));
                    integerValue = defaultValue;
                }
            } else {
                integerValue = defaultValue;
            }
        } else {
            integerValue = defaultValue;
        }
        return integerValue;
    }

    @CheckReturnValue
    public static long convertToLong(@Nonnull String type, @Nonnull String name, @Nonnull Optional<String> valueToConvert, long defaultValue) {
        return ValueConverter.convertToLong(type, name, valueToConvert, Optional.of(defaultValue)).get();
    }

    @CheckReturnValue
    public static Optional<Long> convertToLong(@Nonnull String type, @Nonnull String name, @Nonnull Optional<String> valueToConvert, @Nonnull Optional<Long> defaultValue) {
        Optional<Long> longValue;
        if (valueToConvert.isPresent()) {
            String value = valueToConvert.get().trim();
            if (value.length() > 0) {
                try {
                    longValue = Optional.of(Long.decode(value));
                }
                catch (NumberFormatException exception) {
                    _LOGGER.warn(BaseMessages.CONVERT_LONG, type, name, value, String.valueOf(defaultValue.orElse(null)));
                    longValue = defaultValue;
                }
            } else {
                longValue = defaultValue;
            }
        } else {
            longValue = defaultValue;
        }
        return longValue;
    }

    @CheckReturnValue
    public static boolean isCanonical(@Nonnull Optional<String> text) {
        if (text.isPresent()) {
            return Normalizer.isNormalized(text.get(), Normalizer.Form.NFC);
        }
        return true;
    }

    @CheckReturnValue
    public static boolean isFalse(@Nonnull String value) {
        return _FALSE_PATTERN.matcher(value).matches();
    }

    @CheckReturnValue
    public static boolean isTrue(@Nonnull String value) {
        return _TRUE_PATTERN.matcher(value).matches();
    }

    @CheckReturnValue
    public static long roundToMebibytes(long bytes) {
        if (bytes < Long.MAX_VALUE) {
            bytes += 524288L;
        }
        return bytes / 0x100000L;
    }

    @Nonnull
    @CheckReturnValue
    public static String[] splitFields(@Nonnull String fields) {
        return _FIELDS_SPLIT_PATTERN.split(fields);
    }

    @Nonnull
    @CheckReturnValue
    public static String[] splitFields(@Nonnull String fields, int max) {
        return _FIELDS_SPLIT_PATTERN.split(fields, max);
    }

    @Nonnull
    @CheckReturnValue
    public static Integer toInteger(boolean value) {
        return value ? 1 : 0;
    }

    @Nonnull
    @CheckReturnValue
    public static Pattern wildToPattern(@Nonnull String wild) {
        StringBuilder stringBuilder = new StringBuilder(wild.length());
        for (int i = 0; i < wild.length(); ++i) {
            char ch = wild.charAt(i);
            if ("\\^$.+([{|".indexOf(ch) >= 0) {
                stringBuilder.append('\\');
                stringBuilder.append(ch);
                continue;
            }
            if (ch == '*') {
                stringBuilder.append(".*?");
                continue;
            }
            if (ch == '?') {
                stringBuilder.append('.');
                continue;
            }
            stringBuilder.append(ch);
        }
        return Pattern.compile(stringBuilder.toString(), 2);
    }
}

