/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class LoginInfo {
    private final Optional<char[]> _password;
    private final Optional<String> _user;

    public LoginInfo(@Nonnull Optional<String> user, @Nonnull Optional<char[]> password) {
        if (user.isPresent() && (user = Optional.of(user.get().trim())).get().isEmpty()) {
            user = Optional.empty();
        }
        if (user.isPresent()) {
            if (!password.isPresent()) {
                password = Optional.of(new char[0]);
            }
        } else {
            password = Optional.empty();
        }
        this._user = user;
        this._password = password;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<char[]> getPassword() {
        return this._password;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<String> getUser() {
        return this._user;
    }

    @CheckReturnValue
    public boolean isEnabled() {
        return this._user.isPresent();
    }
}

