/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util;

import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.Points;
import org.rvpf.base.logger.Message;
import org.rvpf.base.store.StoreSessionProxy;
import org.rvpf.base.store.StoreValuesQuery;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.VersionedValue;

@ThreadSafe
public final class PointValuesDumper
implements Callable<Integer> {
    private final Output _output;
    private final Optional<Points> _points;
    private final StoreValuesQuery _storeQuery;
    private final StoreSessionProxy _storeSessionProxy;

    public PointValuesDumper(@Nonnull StoreValuesQuery storeQuery, @Nonnull StoreSessionProxy storeSessionProxy, @Nonnull Optional<Points> points, @Nonnull Output output) {
        this._storeQuery = Require.notNull(storeQuery);
        this._storeSessionProxy = Require.notNull(storeSessionProxy);
        this._points = Require.notNull(points);
        this._output = Require.notNull(output);
    }

    @Override
    public Integer call() throws Exception {
        if (this._storeQuery.isPull() && !this._storeSessionProxy.supportsPull()) {
            throw new IllegalArgumentException(Message.format(BaseMessages.PULL_QUERIES_NOT_SUPPORTED, new Object[0]));
        }
        int count = 0;
        try {
            for (PointValue pointValue : this._storeSessionProxy.iterate(this._storeQuery, this._points)) {
                this._output.output((VersionedValue)pointValue);
                ++count;
            }
        }
        catch (StoreValuesQuery.IterationException exception) {
            throw exception.getCause();
        }
        this._output.flush();
        return count;
    }

    public static interface Output {
        public void flush() throws Exception;

        public void output(@Nonnull VersionedValue var1) throws Exception;
    }
}

