/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.store.StoreSessionProxy;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;

@ThreadSafe
public final class PointValuesLoader
implements Callable<Integer> {
    public static final int DEFAULT_BATCH_LIMIT = 1000;
    private static final Logger _LOGGER = Logger.getInstance(PointValuesLoader.class);
    private volatile int _batchLimit = 1000;
    private final Input _input;
    private final StoreSessionProxy _storeProxy;

    public PointValuesLoader(@Nonnull StoreSessionProxy storeSessionProxy, @Nonnull Input input) {
        this._storeProxy = Require.notNull(storeSessionProxy);
        this._input = Require.notNull(input);
    }

    @Override
    public Integer call() throws Exception {
        ArrayList<PointValue> pointValues = new ArrayList<PointValue>(this._batchLimit);
        int count = 0;
        while (true) {
            Optional<PointValue> pointValue;
            if (!(pointValue = this._input.input()).isPresent()) break;
            pointValues.add(pointValue.get());
            if (pointValues.size() >= this._batchLimit) {
                this._flush(pointValues);
            }
            ++count;
        }
        this._flush(pointValues);
        return count;
    }

    @CheckReturnValue
    public int getBatchLimit() {
        return this._batchLimit;
    }

    public void setBatchLimit(int batchLimit) {
        this._batchLimit = batchLimit;
    }

    private void _flush(List<PointValue> pointValues) throws Exception {
        if (!this._storeProxy.updateAndCheck(pointValues, _LOGGER)) {
            throw new RuntimeException();
        }
        pointValues.clear();
    }

    public static interface Input {
        public Optional<PointValue> input() throws Exception;
    }
}

