/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public class ProxyReader
extends Reader {
    private volatile Reader _proxied;

    @Override
    public void close() throws IOException {
        Reader proxied = this._proxied;
        if (proxied != null) {
            proxied.close();
        }
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Reader> getProxied() {
        return Optional.ofNullable(this._proxied);
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this._proxied.mark(readAheadLimit);
    }

    @Override
    public boolean markSupported() {
        return this._proxied.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this._proxied.read();
    }

    @Override
    public int read(char[] buffer) throws IOException {
        return this._proxied.read(buffer);
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        return this._proxied.read(target);
    }

    @Override
    public int read(char[] buffer, int offset, int length) throws IOException {
        return this._proxied.read(buffer, offset, length);
    }

    @Override
    public boolean ready() throws IOException {
        return this._proxied.ready();
    }

    @Override
    public void reset() throws IOException {
        this._proxied.reset();
    }

    public void setProxied(@Nonnull Optional<Reader> proxied) {
        this._proxied = proxied.orElse(null);
    }

    @Override
    public long skip(long n) throws IOException {
        return this._proxied.skip(n);
    }
}

