/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util;

import java.io.File;
import java.net.URL;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Logger;

public final class ResourceFileFactory {
    public static final String FILE_PROTOCOL = "file";
    public static final String RESOURCE_PREFIX = "resource:";

    private ResourceFileFactory() {
    }

    @Nullable
    @CheckReturnValue
    public static File newResourceFile(@Nonnull String spec) {
        File resourceFile;
        if ((spec = spec.trim()).startsWith(RESOURCE_PREFIX)) {
            spec = spec.substring(RESOURCE_PREFIX.length());
            URL url = Thread.currentThread().getContextClassLoader().getResource(spec);
            if (url == null) {
                Logger.getInstance(ResourceFileFactory.class).warn(BaseMessages.RESOURCE_NOT_FOUND, spec);
                resourceFile = null;
            } else if (FILE_PROTOCOL.equalsIgnoreCase(url.getProtocol())) {
                resourceFile = new File(url.getFile()).getAbsoluteFile();
            } else {
                Logger.getInstance(ResourceFileFactory.class).warn(BaseMessages.PROTOCOL_NOT_SUPPORTED, url.getProtocol(), url);
                resourceFile = null;
            }
        } else {
            resourceFile = new File(spec);
        }
        return resourceFile;
    }
}

