/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import javax.annotation.concurrent.Immutable;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Message;

@Immutable
public final class ResourceURLHandler
extends URLStreamHandler {
    public static final String RESOURCE_PROTOCOL = "resource";

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        String name = url.getHost();
        String file = url.getFile();
        while (file.startsWith("/")) {
            file = file.substring(1);
        }
        name = name + file;
        url = Thread.currentThread().getContextClassLoader().getResource(name);
        if (url == null) {
            throw new FileNotFoundException(Message.format(BaseMessages.RESOURCE_NOT_FOUND, name));
        }
        return url.openConnection();
    }
}

