/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.base.Point;
import org.rvpf.base.sync.Sync;
import org.rvpf.base.tool.Require;

public class Schedule<E extends Event>
extends AbstractSet<E>
implements Iterator<E> {
    private boolean _busy;
    private volatile boolean _cancelWait;
    private final NavigableSet<E> _events = new TreeSet();
    private final boolean _future;
    private final Object _mutex = new Object();
    private E _returnedEvent;

    public Schedule(boolean future) {
        this._future = future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean add(E event) {
        boolean added;
        Object object = this._mutex;
        synchronized (object) {
            added = this._events.add(event);
            this._mutex.notifyAll();
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void advance() {
        Object object = this._mutex;
        synchronized (object) {
            Require.failure(this._busy);
            if (this._returnedEvent != null) {
                this._events.remove(this._returnedEvent);
                this._returnedEvent.advance(this._future);
                this._events.add(this._returnedEvent);
                this._returnedEvent = null;
            }
        }
    }

    public final void cancel(@Nonnull E event) {
        long eventId = event.getId();
        Iterator<E> iterator = this._events.iterator();
        while (iterator.hasNext()) {
            Event scheduledEvent = (Event)iterator.next();
            if (scheduledEvent.getId() != eventId) continue;
            iterator.remove();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear() {
        Object object = this._mutex;
        synchronized (object) {
            this._events.clear();
            this._mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean contains(Object object) {
        NavigableSet<E> navigableSet = this._events;
        synchronized (navigableSet) {
            return this._events.contains(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean containsAll(Collection<?> collection) {
        Object object = this._mutex;
        synchronized (object) {
            return this._events.containsAll(collection);
        }
    }

    @Override
    public final boolean equals(Object other) {
        return this == other;
    }

    @CheckReturnValue
    public final long getDelay() {
        Optional<E> firstEvent = this.peek();
        Require.success(firstEvent.isPresent());
        return ((Event)firstEvent.get()).getDelay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean hasNext() {
        Object object = this._mutex;
        synchronized (object) {
            return !this.isEmpty();
        }
    }

    @Override
    public final int hashCode() {
        return System.identityHashCode(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isEmpty() {
        Object object = this._mutex;
        synchronized (object) {
            return this._events.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Iterator<E> iterator() {
        Object object = this._mutex;
        synchronized (object) {
            Require.failure(this._busy);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E next() {
        Object object = this._mutex;
        synchronized (object) {
            try {
                return (E)((Event)this.next(true).get());
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @CheckReturnValue
    public final Optional<E> peek() {
        Object object = this._mutex;
        synchronized (object) {
            return this.isEmpty() ? Optional.empty() : Optional.of(this._events.first());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void remove() {
        Object object = this._mutex;
        synchronized (object) {
            Require.failure(this._busy);
            if (this._returnedEvent != null) {
                this._events.remove(this._returnedEvent);
                this._returnedEvent = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean remove(Object object) {
        boolean removed;
        Object object2 = this._mutex;
        synchronized (object2) {
            removed = this._events.remove(object);
            if (removed && this._returnedEvent != null && this._returnedEvent.compareTo((Event)((Event)object)) == 0) {
                Require.failure(this._busy);
                this._returnedEvent = null;
            }
        }
        return removed;
    }

    @Override
    public final boolean removeAll(Collection<?> collection) {
        boolean modified = false;
        for (Object object : collection) {
            modified |= this.remove(object);
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean retainAll(Collection<?> collection) {
        boolean modified = false;
        Object object = this._mutex;
        synchronized (object) {
            Iterator<E> iterator = this._events.iterator();
            while (iterator.hasNext()) {
                Event event = (Event)iterator.next();
                if (collection.contains(event)) continue;
                iterator.remove();
                if (event == this._returnedEvent) {
                    Require.failure(this._busy);
                    this._returnedEvent = null;
                }
                modified = true;
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int size() {
        Object object = this._mutex;
        synchronized (object) {
            return this._events.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object[] toArray() {
        Object object = this._mutex;
        synchronized (object) {
            return this._events.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> T[] toArray(T[] array) {
        Object object = this._mutex;
        synchronized (object) {
            return this._events.toArray(array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String toString() {
        Object object = this._mutex;
        synchronized (object) {
            return this._events.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelWait() {
        Object object = this._mutex;
        synchronized (object) {
            this._cancelWait = true;
            this._mutex.notifyAll();
        }
    }

    @Nonnull
    @CheckReturnValue
    protected NavigableSet<E> getEvents() {
        return this._events;
    }

    @Nonnull
    @CheckReturnValue
    protected final Object getMutex() {
        return this._mutex;
    }

    @Nonnull
    @CheckReturnValue
    protected final Optional<E> next(boolean wait) throws InterruptedException {
        block3: {
            this.advance();
            this._busy = true;
            do {
                Event firstEvent;
                if ((firstEvent = (Event)this.peek().orElse(null)) == null) {
                    throw new NoSuchElementException();
                }
                long delay = firstEvent.getDelay();
                if (delay <= 0L) {
                    this._returnedEvent = firstEvent;
                    break block3;
                }
                if (!wait) break block3;
                this._cancelWait = false;
                this._mutex.wait(delay);
            } while (!this._cancelWait);
            this._returnedEvent = null;
        }
        this._busy = false;
        return Optional.ofNullable(this._returnedEvent);
    }

    protected final void rollback() {
        this._returnedEvent = null;
    }

    boolean _isSkipPastEvents() {
        return this._future;
    }

    public static class PointEvent
    extends Event.Abstract {
        private final Optional<Point> _point;

        public PointEvent(@Nonnull Optional<Point> point, @Nonnull DateTime startStamp, @Nonnull Sync sync) {
            super(startStamp, sync);
            this._point = point;
        }

        @Nonnull
        @CheckReturnValue
        public final Optional<Point> getPoint() {
            return this._point;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
            stringBuilder.append(" #");
            stringBuilder.append(this.getId());
            stringBuilder.append(" at ");
            stringBuilder.append(this.getStamp());
            stringBuilder.append(" for '");
            stringBuilder.append((Object)this.getPoint().orElse(null));
            stringBuilder.append("'");
            return stringBuilder.toString();
        }
    }

    public static interface Event
    extends Comparable<Event> {
        public void advance(boolean var1);

        @CheckReturnValue
        public long getDelay();

        @CheckReturnValue
        public long getId();

        @Nonnull
        @CheckReturnValue
        public DateTime getStamp();

        public static abstract class Abstract
        implements Event {
            private static final AtomicLong _nextId = new AtomicLong(1L);
            private final long _id = _nextId.getAndIncrement();
            private DateTime _stamp;
            private final Sync _sync;

            Abstract(@Nonnull DateTime startStamp, @Nonnull Sync sync) {
                this._stamp = Require.notNull(startStamp);
                this._sync = sync;
                if (!this._sync.isInSync(startStamp)) {
                    this._stamp = this._sync.getNextStamp().orElse(null);
                }
            }

            @Override
            public final void advance(boolean future) {
                DateTime now;
                this._stamp = this._sync.getNextStamp().orElse(null);
                if (future && this._stamp != null && this._stamp.isNotAfter(now = DateTime.now())) {
                    this._stamp = this._sync.getNextStamp(now).orElse(null);
                }
            }

            @Override
            public int compareTo(Event otherEvent) {
                int comparison = this.getStamp().compareTo(otherEvent.getStamp());
                if (comparison == 0) {
                    comparison = Long.compare(this.getId(), otherEvent.getId());
                }
                return comparison;
            }

            public boolean equals(Object object) {
                if (object == null || object.getClass() != this.getClass()) {
                    return false;
                }
                return this.compareTo((Event)object) == 0;
            }

            @Override
            public long getDelay() {
                return this.getStamp().toMillis() - System.currentTimeMillis();
            }

            @Override
            public long getId() {
                return this._id;
            }

            @Override
            public final DateTime getStamp() {
                return this._stamp;
            }

            public int hashCode() {
                return this.getStamp().hashCode();
            }
        }
    }
}

