/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.rvpf.base.UUID;

@Immutable
public final class SignalTarget {
    public static final String NAME_FIELD = "name";
    public static final String REFERENCE_FIELD = "reference";
    public static final String UUID_FIELD = "uuid";
    private static final int _NAME_GROUP = 1;
    private static final int _REFERENCE_GROUP = 3;
    private static final int _UUID_GROUP = 2;
    private static final Pattern _SIGNAL_TARGET_PATTERN = Pattern.compile("\\((?:\\[(.*?)\\])?+,\\s*+(?:([0-9A-F]{8}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{12}))?,\\s*+(?:(.*))?\\)", 2);
    private final Optional<String> _name;
    private final Optional<String> _reference;
    private final Optional<UUID> _uuid;

    public SignalTarget(@Nonnull Optional<String> name, @Nonnull Optional<UUID> uuid, @Nonnull Optional<String> reference) {
        this._name = name;
        this._uuid = uuid;
        this._reference = reference;
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<SignalTarget> fromString(@Nonnull Optional<String> string) {
        SignalTarget signalTarget;
        if (string.isPresent()) {
            Matcher matcher = _SIGNAL_TARGET_PATTERN.matcher(string.get().trim());
            if (matcher.matches()) {
                String uuidGroup = matcher.group(2);
                signalTarget = new SignalTarget(Optional.ofNullable(matcher.group(1)), uuidGroup != null ? UUID.fromString(uuidGroup) : Optional.empty(), Optional.ofNullable(matcher.group(3)));
            } else {
                signalTarget = null;
            }
        } else {
            signalTarget = null;
        }
        return Optional.ofNullable(signalTarget);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof SignalTarget) {
            SignalTarget otherSignalTarget = (SignalTarget)other;
            return Objects.equals(this._name, otherSignalTarget._name) && Objects.equals(this._uuid, otherSignalTarget._uuid) && Objects.equals(this._reference, otherSignalTarget._reference);
        }
        return false;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<String> getName() {
        return this._name;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<String> getReference() {
        return this._reference;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<UUID> getUUID() {
        return this._uuid;
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        if (this._name.isPresent()) {
            stringBuilder.append('[');
            stringBuilder.append(this._name.get());
            stringBuilder.append(']');
        }
        stringBuilder.append(",");
        if (this._uuid.isPresent()) {
            stringBuilder.append(this._uuid.get());
        }
        stringBuilder.append(",");
        if (this._reference.isPresent()) {
            stringBuilder.append("'");
            stringBuilder.append(this._reference.get());
            stringBuilder.append("'");
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

