/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.DateTime;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;

@ThreadSafe
public final class SnoozeAlarm {
    public static final String DEFAULT_MINIMUM_SNOOZE_MILLIS = "1000";
    public static final String MINIMUM_SNOOZE_MILLIS_PROPERTY = "rvpf.snooze.minimum.millis";
    private static volatile long _minimumSnoozeMillis;
    private static volatile ElapsedTime _minimumSnoozeTime;
    @GuardedBy(value="_sync")
    private boolean _closed;
    @GuardedBy(value="_sync")
    private int _snooze;
    private final Object _sync;

    public SnoozeAlarm() {
        this._sync = this;
    }

    public SnoozeAlarm(@Nonnull Object sync) {
        this._sync = sync;
    }

    @CheckReturnValue
    public static boolean validate(@Nonnull ElapsedTime time, @Nonnull Object caller, @Nonnull Messages.Entry nameEntry) {
        Require.notNull(caller);
        Require.notNull(nameEntry);
        if (time.compareTo(SnoozeAlarm._getMinimumSnoozeTime()) < 0) {
            Logger.getInstance(caller.getClass()).error(BaseMessages.SNOOZE_TIME_LOW, nameEntry, time, SnoozeAlarm._getMinimumSnoozeTime());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this._sync;
        synchronized (object) {
            if (!this._closed) {
                this._closed = true;
                this.wakeUp();
            }
        }
    }

    public void snooze() throws InterruptedException {
        Require.ignored(this.snooze(Optional.of(DateTime.END_OF_TIME)));
    }

    @CheckReturnValue
    public boolean snooze(@Nonnull ElapsedTime snoozeTime) throws InterruptedException {
        if (snoozeTime.toMillis() < SnoozeAlarm._getMinimumSnoozeMillis()) {
            throw new IllegalArgumentException(Message.format(BaseMessages.SNOOZE_TIME_LOW, "?", ElapsedTime.fromMillis(snoozeTime.toMillis()), SnoozeAlarm._getMinimumSnoozeTime()));
        }
        DateTime now = DateTime.fromMillis(System.currentTimeMillis());
        Optional<DateTime> wakeTime = Optional.of(now.after(snoozeTime));
        return this.snooze(wakeTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    public boolean snooze(@Nonnull Optional<DateTime> wakeTime) throws InterruptedException {
        long wakeMillis = wakeTime.orElse(DateTime.END_OF_TIME).toMillis();
        Object object = this._sync;
        synchronized (object) {
            if (!this._closed) {
                int snooze = this._snooze;
                do {
                    long snoozeMillis;
                    if ((snoozeMillis = wakeMillis - System.currentTimeMillis()) <= 0L) {
                        return true;
                    }
                    this._sync.wait(snoozeMillis);
                } while (this._snooze == snooze);
            }
            if (this._closed) {
                throw new InterruptedException();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp() {
        Object object = this._sync;
        synchronized (object) {
            ++this._snooze;
            this._sync.notifyAll();
        }
    }

    private static long _getMinimumSnoozeMillis() {
        if (_minimumSnoozeMillis < 1L && (_minimumSnoozeMillis = Long.parseLong(System.getProperty(MINIMUM_SNOOZE_MILLIS_PROPERTY, DEFAULT_MINIMUM_SNOOZE_MILLIS))) < 1L) {
            Logger.getInstance(SnoozeAlarm.class).warn(BaseMessages.ELAPSED_TOO_SMALL, _minimumSnoozeMillis);
            _minimumSnoozeMillis = Long.parseLong(DEFAULT_MINIMUM_SNOOZE_MILLIS);
        }
        return _minimumSnoozeMillis;
    }

    private static ElapsedTime _getMinimumSnoozeTime() {
        if (_minimumSnoozeTime == null) {
            _minimumSnoozeTime = ElapsedTime.fromMillis(SnoozeAlarm._getMinimumSnoozeMillis());
        }
        return _minimumSnoozeTime;
    }
}

