/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util;

import java.io.File;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.LongSupplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedValues;

public final class StorageMonitor {
    public static final String FREE_ALERT_PROPERTY = "free.alert";
    public static final String FREE_WARN_PROPERTY = "free.warn";
    public static final String ROOT_DIR_PROPERTY = "root.dir";
    private static final Set<State> _CHECKED_STATES = EnumSet.range(State.NORMAL, State.ALERTED);
    private static final Set<State> _READY_STATES = EnumSet.range(State.INITIAL, State.ALERTED);
    private long _available = Long.MAX_VALUE;
    private long _freeAlert;
    private long _freeWarn;
    private final Logger _logger;
    private final Optional<StateTransitionHandler> _onAlert;
    private final Optional<StateTransitionHandler> _onWarn;
    private File _rootDir;
    private volatile State _state = State.UNAVAILABLE;
    private LongSupplier _usableSpaceSupplier = this::_getUsableSpace;

    public StorageMonitor(@Nonnull Logger logger) {
        this(logger, Optional.empty(), Optional.empty());
    }

    public StorageMonitor(@Nonnull Logger logger, @Nonnull Optional<StateTransitionHandler> onWarn, @Nonnull Optional<StateTransitionHandler> onAlert) {
        this._logger = Require.notNull(logger);
        this._onWarn = onWarn;
        this._onAlert = onAlert;
    }

    @CheckReturnValue
    public boolean check() {
        boolean alerted;
        boolean warned;
        Require.success(_READY_STATES.contains((Object)this._state));
        if (this._state != State.INITIAL && this._freeAlert == 0L && this._freeWarn == 0L) {
            return true;
        }
        long usableSpace = this._usableSpaceSupplier.getAsLong();
        if (this._available >= this._freeWarn && usableSpace < this._freeWarn) {
            warned = this._onWarn.isPresent() ? this._onWarn.get().onTransition(true) : false;
            if (!warned) {
                this._logger.warn(BaseMessages.STORAGE_UNDER_WARN, (int)(this._freeWarn / 1000000L));
            }
            this._state = State.WARNED;
        }
        if (this._available >= this._freeAlert) {
            if (usableSpace < this._freeAlert) {
                alerted = this._onAlert.isPresent() ? this._onAlert.get().onTransition(true) : false;
                if (!alerted) {
                    this._logger.warn(BaseMessages.STORAGE_UNDER_ALERT, (int)(this._freeAlert / 1000000L));
                }
                this._state = State.ALERTED;
            }
        } else if (usableSpace >= this._freeAlert) {
            alerted = this._onAlert.isPresent() ? this._onAlert.get().onTransition(false) : false;
            if (!alerted) {
                this._logger.info(BaseMessages.STORAGE_NOT_UNDER_ALERT, (int)(this._freeAlert / 1000000L));
            }
            this._state = State.WARNED;
        }
        if (this._state == State.WARNED && usableSpace >= this._freeWarn) {
            warned = this._onWarn.isPresent() ? this._onWarn.get().onTransition(false) : false;
            if (!warned) {
                this._logger.info(BaseMessages.STORAGE_NOT_UNDER_WARN, (int)(this._freeWarn / 1000000L));
            }
            this._state = State.NORMAL;
        }
        this._available = usableSpace;
        if (this._state == State.INITIAL) {
            this._state = State.NORMAL;
        }
        return usableSpace >= this._freeAlert;
    }

    @CheckReturnValue
    public long getAvailable() {
        return _CHECKED_STATES.contains((Object)this._state) ? this._available : this._usableSpaceSupplier.getAsLong();
    }

    @CheckReturnValue
    public int getFree() {
        return (int)(this.getAvailable() / 1000000L);
    }

    @CheckReturnValue
    public State getState() {
        return this._state;
    }

    @CheckReturnValue
    public boolean setUp(@Nonnull KeyedValues storageProperties, @Nonnull File defaultRootDir) {
        Require.notNull(defaultRootDir);
        if (this._state != State.UNAVAILABLE) {
            this.tearDown();
        }
        this._state = State.UNSTABLE;
        this._freeWarn = (long)storageProperties.getInt(FREE_WARN_PROPERTY, 0) * 1000000L;
        this._freeAlert = (long)storageProperties.getInt(FREE_ALERT_PROPERTY, 0) * 1000000L;
        String rootDirString = storageProperties.getString(ROOT_DIR_PROPERTY, Optional.of("")).get();
        this._rootDir = rootDirString.isEmpty() ? defaultRootDir : new File(rootDirString);
        this._state = State.INITIAL;
        return true;
    }

    public void setUsableSpaceSupplier(@Nonnull LongSupplier usableSpaceSupplier) {
        this._usableSpaceSupplier = Require.notNull(usableSpaceSupplier);
    }

    public void tearDown() {
        this._rootDir = null;
        this._freeAlert = 0L;
        this._freeWarn = 0L;
        this._available = Long.MAX_VALUE;
        this._state = State.UNAVAILABLE;
    }

    private long _getUsableSpace() {
        Require.success(_READY_STATES.contains((Object)this._state));
        return this._rootDir.getUsableSpace();
    }

    public static interface StateTransitionHandler {
        public boolean onTransition(boolean var1);
    }

    public static enum State {
        UNAVAILABLE,
        UNSTABLE,
        INITIAL,
        NORMAL,
        WARNED,
        ALERTED;

    }
}

