/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util;

import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.tool.Require;

@ThreadSafe
public final class URLHandlerFactory
implements URLStreamHandlerFactory {
    private static URLHandlerFactory _instance;
    private final Map<String, URLStreamHandler> _handlers = new ConcurrentHashMap<String, URLStreamHandler>();

    private URLHandlerFactory() {
    }

    public static synchronized void register(@Nonnull String protocol, @Nonnull URLStreamHandler handler) {
        if (_instance == null) {
            _instance = new URLHandlerFactory();
            URL.setURLStreamHandlerFactory(_instance);
        }
        _instance._put(Require.notNull(protocol), Require.notNull(handler));
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        return this._handlers.get(protocol);
    }

    private void _put(String protocol, URLStreamHandler handler) {
        this._handlers.put(protocol, handler);
    }
}

