/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util;

import javax.annotation.concurrent.Immutable;
import org.rvpf.base.logger.Logger;

@Immutable
public class UncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        Thread.UncaughtExceptionHandler exceptionHandler = thread.getUncaughtExceptionHandler();
        if (exceptionHandler != thread.getThreadGroup()) {
            exceptionHandler.uncaughtException(thread, throwable);
        } else {
            try {
                if (!Logger.isShutDown()) {
                    Logger.getInstance(this.getClass()).uncaughtException(thread, throwable);
                    return;
                }
                return;
            }
            catch (Throwable throwable2) {
                System.err.print("Exception in thread \"" + thread.getName() + "\": ");
                throwable.printStackTrace(System.err);
            }
        }
    }
}

