/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.tool.Require;

@ThreadSafe
public class UnicodeStreamReader
extends Reader {
    private InputStreamReader _reader;
    private final PushbackInputStream _stream;

    public UnicodeStreamReader(@Nonnull File inputFile) throws FileNotFoundException {
        this(new FileInputStream(inputFile));
    }

    public UnicodeStreamReader(@Nonnull InputStream stream) {
        this._stream = new PushbackInputStream(Require.notNull(stream), 3);
    }

    public UnicodeStreamReader(@Nonnull String inputPath) throws FileNotFoundException {
        this(new File(inputPath));
    }

    @Override
    public void close() throws IOException {
        if (this._reader != null) {
            this._reader.close();
        } else {
            this._stream.close();
        }
    }

    @Nonnull
    @CheckReturnValue
    public String getEncoding() throws IOException {
        String encoding = Objects.requireNonNull(this._getReader().getEncoding());
        return encoding;
    }

    @Override
    public int read() throws IOException {
        return this._getReader().read();
    }

    @Override
    public int read(char[] buffer, int offset, int length) throws IOException {
        return this._getReader().read(buffer, offset, length);
    }

    @Override
    public boolean ready() throws IOException {
        return this._getReader().ready();
    }

    private synchronized InputStreamReader _getReader() throws IOException {
        if (this._reader == null) {
            String charsetName;
            int unread;
            byte[] bom = new byte[2];
            int read = this._stream.read(bom);
            if (read < 2) {
                unread = read;
                charsetName = StandardCharsets.UTF_8.name();
            } else if (bom[0] == -17 && bom[1] == -69) {
                int next = this._stream.read();
                if ((byte)next == -65) {
                    unread = 0;
                } else {
                    this._stream.unread(next);
                    unread = read;
                }
                charsetName = StandardCharsets.UTF_8.name();
            } else if (bom[0] == -1 && bom[1] == -2 || bom[0] == -2 && bom[1] == -1) {
                unread = read;
                charsetName = StandardCharsets.UTF_16.name();
            } else if (bom[0] != 0 && bom[1] == 0) {
                unread = read;
                charsetName = StandardCharsets.UTF_16LE.name();
            } else if (bom[0] == 0 && bom[1] != 0) {
                unread = read;
                charsetName = StandardCharsets.UTF_16BE.name();
            } else {
                unread = read;
                charsetName = StandardCharsets.UTF_8.name();
            }
            if (unread > 0) {
                this._stream.unread(bom, 0, unread);
            }
            this._reader = new InputStreamReader((InputStream)this._stream, charsetName);
        }
        return this._reader;
    }
}

