/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util.container;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.Bag;

@NotThreadSafe
public class HashCounterBag<E>
extends AbstractCollection<E>
implements Bag<E> {
    private final Map<E, Integer> _map = new LinkedHashMap<E, Integer>();

    @Override
    public boolean add(E element) {
        Integer count = this._map.get(Require.notNull(element));
        this._map.put(element, count != null ? count + 1 : 1);
        return true;
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public boolean contains(Object element) {
        return this._map.containsKey(element);
    }

    @Override
    public int count(E element) {
        Integer count = this._map.get(element);
        return count != null ? count : 0;
    }

    @Override
    public Iterator<E> iterator() {
        return this._map.keySet().iterator();
    }

    @Override
    public boolean remove(Object element) {
        Integer count = this._map.get(element);
        if (count == null) {
            return false;
        }
        if (count > 1) {
            this._map.put(element, count - 1);
        } else {
            this._map.remove(element);
        }
        return true;
    }

    @Override
    public int size() {
        return this._map.size();
    }
}

