/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util.container;

import java.util.Iterator;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.rvpf.base.tool.Require;

@Immutable
public final class IdentityDeputy<E> {
    private final E _represented;

    public IdentityDeputy(@Nonnull E represented) {
        this._represented = Require.notNull(represented);
    }

    @Nonnull
    @CheckReturnValue
    public static <E> Iterator<E> iterator(@Nonnull Iterator<IdentityDeputy<E>> iterator) {
        return new _DeputyIterator<E>(Require.notNull(iterator));
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() == this.getClass()) {
            return ((IdentityDeputy)object)._getRepresented() == this._getRepresented();
        }
        return false;
    }

    public int hashCode() {
        return System.identityHashCode(this._represented);
    }

    @Nonnull
    @CheckReturnValue
    E _getRepresented() {
        return this._represented;
    }

    private static class _DeputyIterator<E>
    implements Iterator<E> {
        private final Iterator<IdentityDeputy<E>> _iterator;

        _DeputyIterator(@Nonnull Iterator<IdentityDeputy<E>> iterator) {
            this._iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public E next() {
            return this._iterator.next()._getRepresented();
        }
    }
}

