/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util.container;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Message;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedValues;

@NotThreadSafe
public class KeyedGroups
extends KeyedValues {
    public static final KeyedGroups MISSING_KEYED_GROUP;
    public static final KeyedGroups[] NO_KEYED_GROUPS;
    private static final long serialVersionUID = 1L;
    private final KeyedValues _groups;
    private final String _name;

    public KeyedGroups() {
        this(BaseMessages.VALUE_TYPE.toString(), Optional.empty());
    }

    protected KeyedGroups(@Nonnull KeyedGroups other) {
        super(other);
        this._name = other._name;
        this._groups = other._groups.copy();
    }

    protected KeyedGroups(@Nonnull String type, @Nonnull Optional<String> name) {
        super(type);
        this._name = name.orElse(null);
        this._groups = new KeyedValues(Message.format(BaseMessages.GROUP_TYPE, this.getType()));
    }

    public final void addAll(@Nonnull KeyedGroups keyedGroups) {
        super.addAll(keyedGroups);
        for (Map.Entry<String, List<Object>> entry : keyedGroups.getGroupsEntries()) {
            String key = entry.getKey();
            for (Object group : entry.getValue()) {
                this.addGroup(key, (KeyedGroups)group);
            }
        }
    }

    public void addGroup(@Nonnull String key, @Nonnull KeyedGroups properties) {
        this._groups.addObject(key, properties);
    }

    @Override
    public final void clear() {
        super.clear();
        this._groups.clear();
    }

    @CheckReturnValue
    public boolean containsGroupKey(@Nonnull String key) {
        return this._groups.containsValueKey(key);
    }

    @Override
    public KeyedGroups copy() {
        return new KeyedGroups(this);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        return this._groups.equals(((KeyedGroups)other)._groups);
    }

    @Override
    public KeyedGroups freeze() {
        if (!this.isFrozen()) {
            super.freeze();
            for (Map.Entry<String, List<Object>> groupsEntry : this._groups.getValuesEntries()) {
                for (Object group : groupsEntry.getValue()) {
                    ((KeyedGroups)group).freeze();
                }
            }
        }
        return this;
    }

    @Override
    public KeyedGroups frozen() {
        return (KeyedGroups)super.frozen();
    }

    @Nonnull
    @CheckReturnValue
    public KeyedGroups getGroup(@Nonnull String key) {
        Optional<?> group = this._groups.getObject(Require.notNull(key));
        return group.isPresent() ? (KeyedGroups)group.get() : this.getMissingGroup();
    }

    @Nonnull
    @CheckReturnValue
    public KeyedGroups[] getGroups(@Nonnull String key) {
        return this._groups.getObjects(key).toArray(this.getNoGroups());
    }

    @Nonnull
    @CheckReturnValue
    public final Set<Map.Entry<String, List<Object>>> getGroupsEntries() {
        return Collections.unmodifiableSet(this._groups.getValuesEntries());
    }

    @Nonnull
    @CheckReturnValue
    public final Set<String> getGroupsKeys() {
        return this._groups.getValuesKeys();
    }

    @CheckReturnValue
    public int getGroupsSize() {
        return this._groups.getValuesSize();
    }

    public final Optional<String> getName() {
        return Optional.ofNullable(this._name);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this._groups.isEmpty();
    }

    @CheckReturnValue
    public boolean isMissing() {
        return false;
    }

    public final void removeGroup(@Nonnull String key) {
        this._groups.removeValue(key);
    }

    public final void setGroup(@Nonnull String key, @Nonnull KeyedGroups properties) {
        this._groups.setValue(key, properties);
    }

    @Override
    public void setValue(String key, Object value) {
        super.setValue(key, value);
    }

    @Override
    public KeyedGroups thawed() {
        return this.isFrozen() ? this.copy() : this;
    }

    @Nonnull
    @CheckReturnValue
    public final Map<String, String> toPropertiesMap() {
        Set<String> keys = this.getValuesKeys();
        LinkedHashMap<String, String> propertiesMap = new LinkedHashMap<String, String>(KeyedGroups.hashCapacity(keys.size()));
        for (String key : keys) {
            propertiesMap.put(key, this.getString(key).orElse(null));
        }
        return propertiesMap;
    }

    @Nonnull
    @CheckReturnValue
    protected KeyedGroups getMissingGroup() {
        return MISSING_KEYED_GROUP;
    }

    @Nonnull
    @CheckReturnValue
    protected KeyedGroups[] getNoGroups() {
        return NO_KEYED_GROUPS;
    }

    static {
        NO_KEYED_GROUPS = new KeyedGroups[0];
        MISSING_KEYED_GROUP = new KeyedGroups(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isMissing() {
                return true;
            }
        };
        MISSING_KEYED_GROUP.freeze();
    }
}

