/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util.container;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.ClassDef;
import org.rvpf.base.ClassDefImpl;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.tool.Require;
import org.rvpf.base.tool.ValueConverter;
import org.rvpf.base.util.container.ListLinkedHashMap;

@NotThreadSafe
public class KeyedValues
implements Serializable {
    public static final String ANONYMOUS = "\u0000";
    public static final float HASH_LOAD_FACTOR = 0.75f;
    protected static final Comparator<Map.Entry<String, List<Object>>> MAP_ENTRY_COMPARATOR = Comparator.comparing(Map.Entry::getKey);
    private static final ClassDef[] _NO_CLASS_DEFS = new ClassDef[0];
    private static final Pattern _VARIABLE_PATTERN = Pattern.compile("\\$(\\$?+)\\{(.+?)\\}");
    private static final long serialVersionUID = 1L;
    private transient boolean _frozen;
    private transient boolean _hidden;
    private transient Set<String> _hiddenValues;
    private final String _type;
    private final ListLinkedHashMap<String, Object> _values;

    public KeyedValues() {
        this(BaseMessages.VALUE_TYPE.toString());
    }

    public KeyedValues(@Nonnull String type) {
        this._type = Require.notNull(type);
        this._values = new ListLinkedHashMap(4);
    }

    protected KeyedValues(@Nonnull KeyedValues other) {
        this._type = other._type;
        this._values = (ListLinkedHashMap)other._values.clone();
        this._hidden = other._hidden;
        if (other._hiddenValues != null) {
            this._hiddenValues = new HashSet<String>(other._hiddenValues);
        }
    }

    @CheckReturnValue
    public static int hashCapacity(int count) {
        return 1 + (int)((float)count / 0.75f);
    }

    public void add(@Nonnull String key, @Nonnull Object value) {
        this.addObject(key, value);
    }

    public final void addAll(@Nonnull KeyedValues keyedValues) {
        for (String propertyKey : keyedValues.getValuesKeys()) {
            for (Object value : keyedValues._getValues(propertyKey, Object.class)) {
                this.add(propertyKey, value);
            }
        }
    }

    @CheckReturnValue
    public boolean areValuesHidden(@Nonnull String key) {
        return this._hiddenValues != null ? this._hiddenValues.contains(key) : false;
    }

    public void clear() {
        this.checkNotFrozen();
        this._values.clear();
        this._hiddenValues = null;
    }

    @CheckReturnValue
    public boolean containsValueKey(@Nonnull String key) {
        return this._values.containsKey(Require.notNull(key));
    }

    @Nonnull
    @CheckReturnValue
    public KeyedValues copy() {
        return new KeyedValues(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        KeyedValues otherKeyedValues = (KeyedValues)other;
        if (this._hidden != otherKeyedValues._hidden) {
            return false;
        }
        return this._values.equals(otherKeyedValues._values);
    }

    @Nonnull
    public KeyedValues freeze() {
        this._frozen = true;
        return this;
    }

    @Nonnull
    @CheckReturnValue
    public KeyedValues frozen() {
        KeyedValues frozen;
        if (this.isFrozen()) {
            frozen = this;
        } else {
            frozen = this.copy();
            frozen.freeze();
        }
        return frozen;
    }

    @CheckReturnValue
    public final boolean getBoolean(@Nonnull String key) {
        return this.getBoolean(key, false);
    }

    @CheckReturnValue
    public final boolean getBoolean(@Nonnull String key, boolean defaultValue) {
        return this.getBoolean(key, Optional.of(defaultValue)).get();
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<Boolean> getBoolean(@Nonnull String key, @Nonnull Optional<Boolean> defaultValue) {
        Object value = this._getValue(key, Boolean.class);
        if (value != null) {
            if (value instanceof String) {
                Optional<Boolean> booleanValue = ValueConverter.convertToBoolean(this.getType(), key, Optional.of((String)value), defaultValue);
                return booleanValue;
            }
            return Optional.of((Boolean)value);
        }
        return defaultValue;
    }

    @Nonnull
    @CheckReturnValue
    public final ClassDef getClassDef(@Nonnull String key, @Nonnull ClassDef defaultClassDef) {
        ClassDef[] classDefs = this.getClassDefs(key);
        if (classDefs.length > 1) {
            this.getThisLogger().warn(BaseMessages.MULTIPLE_VALUES, this.getType(), key);
        }
        return classDefs.length > 0 ? classDefs[0] : Require.notNull(defaultClassDef);
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<ClassDef> getClassDef(@Nonnull String key, @Nonnull Optional<ClassDef> defaultClassDef) {
        ClassDef[] classDefs = this.getClassDefs(key);
        if (classDefs.length > 1) {
            this.getThisLogger().warn(BaseMessages.MULTIPLE_VALUES, this.getType(), key);
        }
        return classDefs.length > 0 ? Optional.of(classDefs[0]) : defaultClassDef;
    }

    @Nonnull
    @CheckReturnValue
    public final ClassDef[] getClassDefs(@Nonnull String key) {
        Object[] values = this._getValues(key, Object.class);
        ClassDef[] classDefs = new ClassDef[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] instanceof ClassDef) {
                classDefs[i] = (ClassDef)values[i];
                continue;
            }
            if (values[i] instanceof String) {
                classDefs[i] = new ClassDefImpl((String)values[i]);
                continue;
            }
            this.getThisLogger().warn(BaseMessages.UNEXPECTED_VALUE_CLASS, this.getType(), key, ClassDef.class.getName(), values[i].getClass().getName());
            return _NO_CLASS_DEFS;
        }
        return classDefs;
    }

    public final double getDouble(@Nonnull String key, double defaultValue) {
        Object objectValue = this._getValue(key, Number.class);
        double doubleValue = objectValue != null ? (objectValue instanceof Number ? ((Number)objectValue).doubleValue() : ValueConverter.convertToDouble(this.getType(), key, Optional.of((String)objectValue), defaultValue)) : defaultValue;
        return doubleValue;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<ElapsedTime> getElapsed(@Nonnull String key, @Nonnull Optional<ElapsedTime> defaultValue, @Nonnull Optional<ElapsedTime> emptyValue) {
        Optional<ElapsedTime> elapsedTime;
        Optional<String> elapsedString = this.getString(key);
        if (!elapsedString.isPresent()) {
            return defaultValue;
        }
        try {
            elapsedTime = ElapsedTime.fromString(Optional.of(elapsedString.get()));
            if (!elapsedTime.isPresent()) {
                elapsedTime = emptyValue;
            }
        }
        catch (IllegalArgumentException exception) {
            this.getThisLogger().warn(BaseMessages.ILLEGAL_ARGUMENT, exception.getMessage());
            elapsedTime = defaultValue;
        }
        return elapsedTime;
    }

    @CheckReturnValue
    public final int getInt(@Nonnull String key, int defaultValue) {
        return this.getInteger(key, Optional.of(defaultValue)).get();
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<Integer> getInteger(@Nonnull String key, @Nonnull Optional<Integer> defaultValue) {
        Object value = this._getValue(key, Number.class);
        Optional<Integer> integerValue = value instanceof Integer ? Optional.of((Integer)value) : (value instanceof String ? ValueConverter.convertToInteger(this.getType(), key, Optional.of((String)value), defaultValue) : (value != null ? Optional.of(((Number)value).intValue()) : defaultValue));
        return integerValue;
    }

    @CheckReturnValue
    public final long getLong(@Nonnull String key, long defaultValue) {
        return this.getLong(key, Optional.of(defaultValue)).get();
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<Long> getLong(@Nonnull String key, @Nonnull Optional<Long> defaultValue) {
        Object value = this._getValue(key, Number.class);
        Optional<Long> longValue = value instanceof Long ? Optional.of((Long)value) : (value instanceof String ? ValueConverter.convertToLong(this.getType(), key, Optional.of((String)value), defaultValue) : (value != null ? Optional.of(((Number)value).longValue()) : defaultValue));
        return longValue;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<?> getObject(@Nonnull String key) {
        Optional<Object> object;
        List<Object> objects = this.getObjects(key);
        if (!objects.isEmpty()) {
            object = Optional.of(objects.get(0));
            if (objects.size() > 1) {
                this.getThisLogger().warn(BaseMessages.MULTIPLE_VALUES, this.getType(), key);
            }
        } else {
            object = Optional.empty();
        }
        return object;
    }

    @Nonnull
    @CheckReturnValue
    public List<Object> getObjects(@Nonnull String key) {
        return this._values.getAll(Require.notNull(key));
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<char[]> getPassword(@Nonnull String key) {
        String password = (String)this._getValue(key, String.class);
        return password != null ? Optional.of(password.toCharArray()) : Optional.empty();
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<String> getString(@Nonnull String key) {
        return Optional.ofNullable((String)this._getValue(key, String.class));
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<String> getString(@Nonnull String key, @Nonnull Optional<String> defaultValue) {
        Optional<String> value = this.getString(key);
        return value.isPresent() ? value : defaultValue;
    }

    @Nonnull
    @CheckReturnValue
    public final String[] getStrings(@Nonnull String key) {
        return this._getValues(key, String.class);
    }

    @Nonnull
    @CheckReturnValue
    public String getType() {
        return this._type;
    }

    @Nonnull
    @CheckReturnValue
    public Object[] getValues(@Nonnull String key) {
        return this.getObjects(key).toArray();
    }

    @Nonnull
    @CheckReturnValue
    public final Set<Map.Entry<String, List<Object>>> getValuesEntries() {
        return this._values.entrySet();
    }

    @Nonnull
    @CheckReturnValue
    public final Set<String> getValuesKeys() {
        return this._values.keySet();
    }

    @CheckReturnValue
    public int getValuesSize() {
        return this._values.size();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @CheckReturnValue
    public boolean isEmpty() {
        return this._values.isEmpty();
    }

    @CheckReturnValue
    public final boolean isFrozen() {
        return this._frozen;
    }

    @CheckReturnValue
    public final boolean isHidden() {
        return this._hidden;
    }

    @CheckReturnValue
    public boolean isMultiple(@Nonnull String key) {
        List<Object> objects = this.getObjects(key);
        return objects != null && objects.size() > 1;
    }

    public void removeValue(@Nonnull String key) {
        this.checkNotFrozen();
        this._values.remove(KeyedValues._validatedKey(key));
    }

    public final void setHidden(boolean hidden) {
        this._hidden = hidden;
    }

    public void setValue(@Nonnull String key, @Nonnull Object value) {
        this.checkNotFrozen();
        key = KeyedValues._validatedKey(key);
        this._values.remove(key);
        this._values.add(key, Require.notNull(value));
    }

    public void setValuesHidden(@Nonnull String key) {
        this.checkNotFrozen();
        if (this._hiddenValues == null) {
            this._hiddenValues = new HashSet<String>();
        }
        this._hiddenValues.add(key);
    }

    @Nonnull
    @CheckReturnValue
    public final String substitute(@Nonnull String text, boolean deferred) {
        Matcher matcher = _VARIABLE_PATTERN.matcher(text);
        StringBuffer buffer = null;
        while (matcher.find()) {
            if (deferred && !matcher.group(1).isEmpty()) continue;
            String name = matcher.group(2);
            String value = this.getString(name, Optional.of("")).get();
            if (buffer == null) {
                buffer = new StringBuffer();
            }
            matcher.appendReplacement(buffer, Matcher.quoteReplacement(value));
        }
        if (buffer != null) {
            matcher.appendTail(buffer);
            text = buffer.toString();
        }
        return text;
    }

    @Nonnull
    @CheckReturnValue
    public KeyedValues thawed() {
        return this.isFrozen() ? this.copy() : this;
    }

    @Nonnull
    @CheckReturnValue
    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(super.hashCode());
    }

    protected final void addObject(@Nonnull String key, @Nonnull Object object) {
        this.checkNotFrozen();
        this._values.add(KeyedValues._validatedKey(key), Require.notNull(object));
    }

    protected final void checkNotFrozen() {
        Require.failure(this._frozen, (Object)BaseMessages.FROZEN);
    }

    @Nonnull
    @CheckReturnValue
    protected final Logger getThisLogger() {
        return Logger.getInstance(this.getClass());
    }

    protected void setObjects(@Nonnull String key, @Nonnull List<Object> objects) {
        this.checkNotFrozen();
        if (objects.isEmpty()) {
            this._values.remove(key);
        } else {
            this._values.put(key, objects);
        }
    }

    private static String _validatedKey(String key) {
        if (key == ANONYMOUS) {
            return "";
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException(Message.format(BaseMessages.EMPTY_KEY, new Object[0]));
        }
        return key;
    }

    private Object _getValue(String key, Class<?> valueClass) {
        Object object = this.getObject(key).orElse(null);
        if (object != null && !(object instanceof String) && !valueClass.isInstance(object)) {
            this.getThisLogger().warn(BaseMessages.UNEXPECTED_VALUE_CLASS, this.getType(), key, valueClass.getName(), object.getClass().getName());
            return null;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T[] _getValues(String key, Class<T> valueClass) {
        List<Object> objects = this.getObjects(key);
        Object[] values = null;
        if (objects != null) {
            try {
                values = objects.toArray((Object[])Array.newInstance(valueClass, objects.size()));
            }
            catch (ArrayStoreException exception) {
                for (Object value : objects) {
                    if (valueClass.isInstance(value)) continue;
                    this.getThisLogger().warn(BaseMessages.UNEXPECTED_VALUE_CLASS, this.getType(), key, valueClass.getName(), value.getClass().getName());
                    break;
                }
            }
        }
        if (values != null) return values;
        return (Object[])Array.newInstance(valueClass, 0);
    }
}

