/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util.container;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.util.container.IdentityDeputy;

@ThreadSafe
public final class Listeners<L>
implements Iterable<L> {
    private final Collection<IdentityDeputy<L>> _listeners = new ConcurrentLinkedQueue<IdentityDeputy<L>>();

    public synchronized boolean add(@Nonnull L listener) {
        IdentityDeputy<L> deputy = new IdentityDeputy<L>(listener);
        if (this._listeners.contains(deputy)) {
            return false;
        }
        this._listeners.add(deputy);
        return true;
    }

    public void clear() {
        this._listeners.clear();
    }

    @CheckReturnValue
    public boolean isEmpty() {
        return this._listeners.isEmpty();
    }

    @Override
    public Iterator<L> iterator() {
        return IdentityDeputy.iterator(this._listeners.iterator());
    }

    public boolean remove(@Nonnull L listener) {
        return this._listeners.remove(new IdentityDeputy<L>(listener));
    }
}

