/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util.container;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Point;
import org.rvpf.base.UUID;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.filter.ValueFilter;

public final class PointValueFilters {
    private final Map<UUID, ValueFilter> _valueFilters = new HashMap<UUID, ValueFilter>();

    public void clear() {
        this._valueFilters.clear();
    }

    @Nonnull
    @CheckReturnValue
    public PointValue[] filter(@Nonnull PointValue pointValue) {
        PointValue[] pointValueArray;
        Optional<Point> point;
        ValueFilter valueFilter = this._valueFilters.get(pointValue.getPointUUID());
        if (valueFilter == null && (point = pointValue.getPoint()).isPresent()) {
            valueFilter = point.get().filter();
            this._valueFilters.put(point.get().getUUID().get(), valueFilter);
        }
        if (valueFilter != null) {
            pointValueArray = valueFilter.filter(Optional.of(pointValue));
        } else {
            PointValue[] pointValueArray2 = new PointValue[1];
            pointValueArray = pointValueArray2;
            pointValueArray2[0] = pointValue;
        }
        return pointValueArray;
    }

    public void filterPoints(@Nonnull Collection<Point> points) {
        for (Point point : points) {
            ValueFilter valueFilter = point.filter();
            if (valueFilter.isDisabled()) continue;
            this._valueFilters.put(point.getUUID().get(), valueFilter);
        }
    }
}

