/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util.rlp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.tool.Require;

@NotThreadSafe
class Datagram {
    private final DatagramPacket _datagramPacket = new DatagramPacket(new byte[65535], 0);
    private int _offset;

    Datagram() {
    }

    @Nonnull
    Datagram addByte(byte addedByte) {
        this._datagramPacket.getData()[this._offset++] = addedByte;
        this._datagramPacket.setLength(this._offset);
        return this;
    }

    @Nonnull
    Datagram addWord(short word) {
        this.addByte((byte)(word >> 8));
        this.addByte((byte)word);
        return this;
    }

    @Nonnull
    @CheckReturnValue
    InetAddress getAddress() {
        return Require.notNull(this._datagramPacket.getAddress());
    }

    @CheckReturnValue
    byte getNextByte() {
        return this._datagramPacket.getData()[this._offset++];
    }

    @CheckReturnValue
    short getNextWord() {
        short word = (short)(this.getNextByte() << 8);
        word = (short)(word | this.getNextByte() & 0xFF);
        return word;
    }

    @CheckReturnValue
    int getOffset() {
        return this._offset;
    }

    @CheckReturnValue
    int getPort() {
        int port = this._datagramPacket.getPort();
        Require.success(port > 0);
        return port;
    }

    @Nonnull
    @CheckReturnValue
    SocketAddress getSocketAddress() {
        return this._datagramPacket.getSocketAddress();
    }

    @CheckReturnValue
    boolean receive(@Nonnull DatagramSocket datagramSocket, int timeoutMillis) throws IOException {
        this.reset();
        this._datagramPacket.setLength(this._datagramPacket.getData().length);
        try {
            datagramSocket.setBroadcast(true);
            datagramSocket.setSoTimeout(timeoutMillis);
            datagramSocket.receive(this._datagramPacket);
        }
        catch (SocketTimeoutException exception) {
            return false;
        }
        catch (SocketException exception) {
            if (!datagramSocket.isClosed()) {
                throw exception;
            }
            return false;
        }
        return true;
    }

    @CheckReturnValue
    int remainingLength() {
        return this._datagramPacket.getLength() - this._offset;
    }

    @Nonnull
    Datagram reset() {
        this._offset = 0;
        return this;
    }

    @CheckReturnValue
    boolean send(@Nonnull DatagramSocket datagramSocket, boolean broadcast) throws IOException {
        try {
            datagramSocket.setBroadcast(broadcast);
            datagramSocket.send(this._datagramPacket);
        }
        catch (SocketException exception) {
            if (!datagramSocket.isClosed()) {
                throw exception;
            }
            return false;
        }
        this.reset();
        return true;
    }

    @Nonnull
    Datagram setRemoteAddress(@Nonnull InetAddress remoteAddress) {
        this._datagramPacket.setAddress(Require.notNull(remoteAddress));
        return this;
    }

    @Nonnull
    Datagram setRemotePort(int remotePort) {
        this._datagramPacket.setPort(remotePort);
        return this;
    }
}

