/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util.rlp;

import java.util.Arrays;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;

enum MessageType {
    WHO_PROVIDES,
    DO_YOU_PROVIDE,
    WHO_ANYWHERE_PROVIDES,
    DOES_ANYONE_PROVIDE,
    I_PROVIDE,
    THEY_PROVIDE;

    private static final MessageType[] _TYPE_ARRAY;

    @Nonnull
    @CheckReturnValue
    public static MessageType instance(int ordinal) {
        Require.failure(ordinal < 0 || _TYPE_ARRAY.length <= ordinal);
        return _TYPE_ARRAY[ordinal];
    }

    static {
        _TYPE_ARRAY = new MessageType[MessageType.values().length];
        Arrays.stream(MessageType.values()).forEach(type -> {
            MessageType._TYPE_ARRAY[type.ordinal()] = type;
        });
    }
}

