/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util.rlp;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public enum Protocol {
    IP(0),
    ICMP(1),
    IGMP(2),
    GGP(3),
    TCP(6),
    EGP(8),
    UDP(17),
    UNKNOWN(-1);

    private static final Map<Integer, Protocol> _MAP;
    private final int _code;

    private Protocol(int code) {
        this._code = code;
    }

    @Nonnull
    @CheckReturnValue
    public static Protocol get(int code) {
        Protocol status = _MAP.get(code);
        return status != null ? status : UNKNOWN;
    }

    @Nonnull
    @CheckReturnValue
    public static String toString(int code) {
        return Protocol.get(code).name() + "(" + code + ")";
    }

    @CheckReturnValue
    public int code() {
        return this._code;
    }

    static {
        _MAP = new HashMap<Integer, Protocol>();
        for (Protocol protocol : Protocol.values()) {
            _MAP.put(protocol.code(), protocol);
        }
    }
}

