/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util.rlp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.channels.InterruptedByTimeoutException;
import java.util.LinkedList;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.Inet;
import org.rvpf.base.util.rlp.Datagram;
import org.rvpf.base.util.rlp.MessageType;
import org.rvpf.base.util.rlp.RLPMessage;
import org.rvpf.base.util.rlp.RLPMessages;
import org.rvpf.base.util.rlp.ResourceProvider;
import org.rvpf.base.util.rlp.ResourceSpecifier;

@ThreadSafe
public class RLPClient {
    private static final Logger _LOGGER = Logger.getInstance(RLPClient.class);
    private final DatagramSocket _datagramSocket;

    RLPClient(@Nonnull InetAddress localAddress, int localPort) throws SocketException {
        this._datagramSocket = new DatagramSocket(localPort, localAddress);
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    public void close() {
        this._datagramSocket.close();
    }

    @Nonnull
    @CheckReturnValue
    public synchronized Optional<ResourceSpecifier[]> doYouProvide(@Nonnull ResourceProvider resourceProvider, @Nonnull ResourceSpecifier[] resourceSpecifiers, boolean local, @Nonnull ElapsedTime timeout) throws IOException, InterruptedByTimeoutException {
        RLPMessage receivedMessage;
        Datagram datagram = new Datagram().setRemoteAddress(resourceProvider.getAddress()).setRemotePort(resourceProvider.getPort());
        RLPMessage sentMessage = RLPClient.newMessage(MessageType.DO_YOU_PROVIDE, resourceSpecifiers, local);
        sentMessage.exportTo(datagram);
        if (!datagram.send(this._datagramSocket, false)) {
            return Optional.empty();
        }
        _LOGGER.trace(RLPMessages.SENT_MESSAGE, this._datagramSocket.getLocalSocketAddress(), datagram.getSocketAddress(), sentMessage);
        do {
            if (!datagram.receive(this._datagramSocket, RLPClient._intMillis(timeout))) {
                return Optional.empty();
            }
            receivedMessage = RLPMessage.newBuilder().importFrom(datagram).build();
            _LOGGER.trace(RLPMessages.RECEIVED_MESSAGE, this._datagramSocket.getLocalSocketAddress(), datagram.getSocketAddress(), receivedMessage);
        } while (receivedMessage.getMessageID() != sentMessage.getMessageID() || receivedMessage.getMessageType() != MessageType.I_PROVIDE);
        return Optional.of(receivedMessage.getResourceSpecifiers());
    }

    @Nonnull
    @CheckReturnValue
    public synchronized Optional<ResourceProvider[]> whoProvides(@Nonnull ResourceProvider resourceProvider, @Nonnull ResourceSpecifier[] resourceSpecifiers, boolean local, @Nonnull ElapsedTime maximumWait, @Nonnull ElapsedTime minimumWait) throws IOException {
        Datagram datagram = new Datagram().setRemoteAddress(resourceProvider.getAddress()).setRemotePort(resourceProvider.getPort());
        RLPMessage sentMessage = RLPClient.newMessage(MessageType.WHO_PROVIDES, resourceSpecifiers, local);
        sentMessage.exportTo(datagram);
        if (!datagram.send(this._datagramSocket, true)) {
            return Optional.empty();
        }
        _LOGGER.trace(RLPMessages.SENT_MESSAGE, this._datagramSocket.getLocalSocketAddress(), datagram.getSocketAddress(), sentMessage);
        LinkedList<ResourceProvider> resourceProviders = new LinkedList<ResourceProvider>();
        int wait = RLPClient._intMillis(maximumWait);
        while (datagram.receive(this._datagramSocket, wait)) {
            RLPMessage receivedMessage = RLPMessage.newBuilder().importFrom(datagram).build();
            _LOGGER.trace(RLPMessages.RECEIVED_MESSAGE, this._datagramSocket.getLocalSocketAddress(), datagram.getSocketAddress(), receivedMessage);
            if (receivedMessage.getMessageID() == sentMessage.getMessageID() && receivedMessage.getMessageType() == MessageType.I_PROVIDE) {
                resourceProviders.add(ResourceProvider.newBuilder().importFrom(receivedMessage).build());
            }
            if ((wait = RLPClient._intMillis(minimumWait)) != 0) continue;
            break;
        }
        return Optional.of(resourceProviders.toArray(new ResourceProvider[resourceProviders.size()]));
    }

    private static int _intMillis(ElapsedTime elapsedTime) {
        long millis = elapsedTime.toMillis();
        return millis <= Integer.MAX_VALUE ? (int)millis : 0;
    }

    private static RLPMessage newMessage(MessageType messageType, ResourceSpecifier[] resourceSpecifiers, boolean local) {
        return RLPMessage.newBuilder().setMessageType(messageType).setResourceSpecifiers(resourceSpecifiers).setLocal(local).build();
    }

    @NotThreadSafe
    public static final class Builder {
        private Optional<InetAddress> _localAddress = Optional.empty();
        private int _localPort;

        Builder() {
        }

        @Nonnull
        @CheckReturnValue
        public RLPClient build() throws SocketException {
            return new RLPClient(this._localAddress.orElse(Inet.getLocalHostAddress()), this._localPort);
        }

        @Nonnull
        public Builder setLocalAddress(@Nonnull Optional<InetAddress> localAddress) {
            this._localAddress = localAddress;
            return this;
        }

        @Nonnull
        public Builder setLocalPort(int localPort) {
            this._localPort = localPort;
            return this;
        }
    }
}

