/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util.rlp;

import java.net.InetAddress;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Random;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.logger.Message;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.rlp.Datagram;
import org.rvpf.base.util.rlp.MessageType;
import org.rvpf.base.util.rlp.RLPMessages;
import org.rvpf.base.util.rlp.ResourceSpecifier;

@Immutable
class RLPMessage {
    static final int LOCAL_MASK = 160;
    private final boolean _local;
    private final short _messageID;
    private final MessageType _messageType;
    private final Optional<InetAddress> _remoteAddress;
    private final int _remotePort;
    private final ResourceSpecifier[] _resourceSpecifiers;

    RLPMessage(@Nonnull MessageType messageType, boolean local, short messageID, @Nonnull ResourceSpecifier[] resourceSpecifiers, @Nonnull Optional<InetAddress> remoteAddress, int remotePort) {
        this._messageType = Require.notNull(messageType);
        this._local = local;
        this._messageID = messageID;
        this._resourceSpecifiers = resourceSpecifiers;
        this._remoteAddress = remoteAddress;
        this._remotePort = remotePort;
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    public void exportTo(@Nonnull Datagram datagram) {
        datagram.reset().addByte((byte)this._messageType.ordinal()).addByte((byte)(this._local ? 160 : 0)).addWord(this._messageID);
        for (ResourceSpecifier resourceSpecifier : this._resourceSpecifiers) {
            byte[] resourceIdentifier = resourceSpecifier.getIdentifier();
            datagram.addByte((byte)resourceSpecifier.getProtocol());
            datagram.addByte((byte)resourceIdentifier.length);
            for (byte resourceID : resourceIdentifier) {
                datagram.addByte(resourceID);
            }
        }
    }

    @CheckReturnValue
    public short getMessageID() {
        return this._messageID;
    }

    @Nonnull
    @CheckReturnValue
    public MessageType getMessageType() {
        return this._messageType;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<InetAddress> getRemoteAddress() {
        return this._remoteAddress;
    }

    @CheckReturnValue
    public int getRemotePort() {
        return this._remotePort;
    }

    @Nonnull
    @CheckReturnValue
    public ResourceSpecifier[] getResourceSpecifiers() {
        return this._resourceSpecifiers;
    }

    @CheckReturnValue
    public boolean isLocal() {
        return this._local;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this._messageType.name());
        if (this.isLocal()) {
            stringBuilder.append(" (local)");
        }
        stringBuilder.append(" ID=");
        stringBuilder.append(this._messageID & 0xFFFF);
        stringBuilder.append(" {");
        for (ResourceSpecifier resourceSpecifier : this._resourceSpecifiers) {
            byte[] resourceIdentifier = resourceSpecifier.getIdentifier();
            stringBuilder.append("[");
            stringBuilder.append(resourceSpecifier.getProtocol());
            if (resourceIdentifier.length > 0) {
                stringBuilder.append(",");
                for (byte identifierByte : resourceIdentifier) {
                    stringBuilder.append(" ");
                    String hexDigits = Integer.toHexString(identifierByte & 0xFF);
                    if (hexDigits.length() < 2) {
                        stringBuilder.append('0');
                    }
                    stringBuilder.append(hexDigits);
                }
            }
            stringBuilder.append("]");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final Random _RANDOM = new Random();
        private boolean _local;
        private short _messageID;
        private MessageType _messageType;
        private Optional<InetAddress> _remoteAddress;
        private int _remotePort;
        private ResourceSpecifier[] _resourceSpecifiers;

        Builder() {
        }

        @Nonnull
        @CheckReturnValue
        public RLPMessage build() {
            RLPMessage message = new RLPMessage(this._messageType, this._local, this._messageID != 0 ? this._messageID : (short)_RANDOM.nextInt(), this._resourceSpecifiers != null ? this._resourceSpecifiers : new ResourceSpecifier[]{}, this._remoteAddress, this._remotePort);
            this._messageID = 0;
            return message;
        }

        @Nonnull
        public Builder importFrom(@Nonnull Datagram datagram) throws IllegalArgumentException {
            MessageType messageType;
            if (datagram.remainingLength() < 4) {
                throw new IllegalArgumentException(Message.format(RLPMessages.DATAGRAM_TOO_SHORT, String.valueOf(datagram.remainingLength())));
            }
            byte typeByte = datagram.getNextByte();
            try {
                messageType = MessageType.instance(typeByte);
            }
            catch (Require.FailureException exception) {
                throw new IllegalArgumentException(Message.format(RLPMessages.UNKNOWN_MESSAGE_TYPE, String.valueOf(typeByte & 0xFF)));
            }
            this.setMessageType(messageType);
            this.setLocal((datagram.getNextByte() & 0xA0) != 0);
            this.setMessageID(datagram.getNextWord());
            LinkedList<ResourceSpecifier> resourceSpecifiers = new LinkedList<ResourceSpecifier>();
            while (datagram.remainingLength() > 0) {
                resourceSpecifiers.add(ResourceSpecifier.newBuilder().importFrom(datagram).build());
            }
            this.setResourceSpecifiers(resourceSpecifiers.toArray(new ResourceSpecifier[resourceSpecifiers.size()]));
            this.setRemoteAddress(Optional.of(datagram.getAddress()));
            this.setRemotePort(datagram.getPort());
            return this;
        }

        @Nonnull
        public Builder setLocal(boolean local) {
            this._local = local;
            return this;
        }

        @Nonnull
        public Builder setMessageID(short messageID) {
            this._messageID = messageID;
            return this;
        }

        @Nonnull
        public Builder setMessageType(@Nonnull MessageType messageType) {
            this._messageType = messageType;
            return this;
        }

        @Nonnull
        public Builder setRemoteAddress(@Nonnull Optional<InetAddress> remoteAddress) {
            this._remoteAddress = remoteAddress;
            return this;
        }

        @Nonnull
        public Builder setRemotePort(int remotePort) {
            this._remotePort = remotePort;
            return this;
        }

        @Nonnull
        public Builder setResourceSpecifiers(@Nonnull ResourceSpecifier[] resourceSpecifiers) {
            this._resourceSpecifiers = resourceSpecifiers;
            return this;
        }
    }
}

