/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util.rlp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.rlp.Datagram;
import org.rvpf.base.util.rlp.MessageType;
import org.rvpf.base.util.rlp.RLPMessage;
import org.rvpf.base.util.rlp.RLPMessages;
import org.rvpf.base.util.rlp.ResourceSpecifier;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;

@NotThreadSafe
public class RLPServer
implements ServiceThread.Target {
    public static final int UDP_PORT = 39;
    private static final Logger _LOGGER = Logger.getInstance(RLPServer.class);
    private DatagramSocket _datagramSocket;
    private final Optional<InetAddress> _localAddress;
    private final int _localPort;
    private final Set<ResourceSpecifier> _resourceSpecifiers;
    private final ServiceThread _thread;

    RLPServer(@Nonnull Set<ResourceSpecifier> resourceSpecifiers, @Nonnull Optional<InetAddress> localAddress, int localPort) {
        this._resourceSpecifiers = resourceSpecifiers;
        this._localAddress = localAddress;
        this._localPort = localPort;
        this._thread = new ServiceThread((ServiceThread.Target)this, "RLP Server");
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    @Nonnull
    @CheckReturnValue
    public Optional<InetAddress> getLocalAddress() {
        return this._localAddress;
    }

    @CheckReturnValue
    public int getLocalPort() {
        return this._localPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        try {
            Datagram datagram = new Datagram();
            RLPMessage.Builder messageBuilder = RLPMessage.newBuilder();
            block13: while (datagram.receive(this._datagramSocket, 0)) {
                try {
                    messageBuilder.importFrom(datagram);
                }
                catch (IllegalArgumentException exception) {
                    _LOGGER.debug(RLPMessages.BAD_DATAGRAM, exception.getMessage());
                    continue;
                }
                RLPMessage receivedMessage = messageBuilder.build();
                _LOGGER.trace(RLPMessages.RECEIVED_MESSAGE, this._datagramSocket.getLocalSocketAddress(), datagram.getSocketAddress(), receivedMessage);
                switch (receivedMessage.getMessageType()) {
                    case DO_YOU_PROVIDE: {
                        this._processProviderRequest(datagram, receivedMessage, true);
                        continue block13;
                    }
                    case DOES_ANYONE_PROVIDE: {
                        continue block13;
                    }
                    case I_PROVIDE: {
                        continue block13;
                    }
                    case THEY_PROVIDE: {
                        continue block13;
                    }
                    case WHO_ANYWHERE_PROVIDES: {
                        continue block13;
                    }
                    case WHO_PROVIDES: {
                        this._processProviderRequest(datagram, receivedMessage, false);
                        continue block13;
                    }
                }
                Require.failure();
            }
        }
        finally {
            this._datagramSocket.close();
        }
    }

    public final void start() throws SocketException {
        _LOGGER.debug((Messages.Entry)ServiceMessages.STARTING_THREAD, this._thread.getName());
        this._datagramSocket = new DatagramSocket(this._localPort, this._localAddress.orElse(null));
        this._thread.start();
    }

    public final void stop(long joinTimeout) {
        _LOGGER.debug((Messages.Entry)ServiceMessages.STOPPING_THREAD, this._thread.getName());
        this._datagramSocket.close();
        Require.ignored(this._thread.join(_LOGGER, joinTimeout));
    }

    private void _processProviderRequest(Datagram datagram, RLPMessage receivedMessage, boolean replyRequired) throws IOException {
        ArrayList<ResourceSpecifier> resourceSpecifiers = new ArrayList<ResourceSpecifier>(receivedMessage.getResourceSpecifiers().length);
        for (ResourceSpecifier resourceSpecifier : receivedMessage.getResourceSpecifiers()) {
            if (!this._resourceSpecifiers.contains(resourceSpecifier)) continue;
            resourceSpecifiers.add(resourceSpecifier);
        }
        if (resourceSpecifiers.size() == 0 && !replyRequired) {
            return;
        }
        RLPMessage.Builder messageBuilder = RLPMessage.newBuilder();
        RLPMessage sentMessage = messageBuilder.setMessageType(MessageType.I_PROVIDE).setMessageID(receivedMessage.getMessageID()).setLocal(false).setResourceSpecifiers(resourceSpecifiers.toArray(new ResourceSpecifier[resourceSpecifiers.size()])).build();
        sentMessage.exportTo(datagram);
        if (!datagram.send(this._datagramSocket, false)) {
            return;
        }
        _LOGGER.trace(RLPMessages.SENT_MESSAGE, this._datagramSocket.getLocalSocketAddress(), datagram.getSocketAddress(), sentMessage);
    }

    @NotThreadSafe
    public static final class Builder {
        private Optional<InetAddress> _localAddress = Optional.empty();
        private int _localPort;
        private final Set<ResourceSpecifier> _resourceSpecifiers = new HashSet<ResourceSpecifier>();

        Builder() {
        }

        public Builder addResourceSpecifier(ResourceSpecifier ... resourceSpecifiers) {
            for (ResourceSpecifier resourceSpecifier : resourceSpecifiers) {
                this._resourceSpecifiers.add(resourceSpecifier);
            }
            return this;
        }

        @Nonnull
        @CheckReturnValue
        public RLPServer build() {
            return new RLPServer(this._resourceSpecifiers, this._localAddress, this._localPort > 0 ? this._localPort : 39);
        }

        @Nonnull
        public Builder setLocalAddress(@Nonnull Optional<InetAddress> localAddress) {
            this._localAddress = localAddress;
            return this;
        }

        @Nonnull
        public Builder setLocalPort(int localPort) {
            this._localPort = localPort;
            return this;
        }
    }
}

