/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util.rlp;

import java.net.InetAddress;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.tool.Inet;
import org.rvpf.base.util.rlp.RLPMessage;
import org.rvpf.base.util.rlp.ResourceSpecifier;

@Immutable
public class ResourceProvider {
    private final InetAddress _address;
    private final int _port;
    private final ResourceSpecifier[] _resourceSpecifiers;

    ResourceProvider(@Nonnull InetAddress address, int port, @Nonnull ResourceSpecifier[] resourceSpecifiers) {
        this._address = address;
        this._port = port;
        this._resourceSpecifiers = resourceSpecifiers;
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    @Nonnull
    @CheckReturnValue
    public InetAddress getAddress() {
        return this._address;
    }

    @CheckReturnValue
    public int getPort() {
        return this._port;
    }

    @Nonnull
    @CheckReturnValue
    public ResourceSpecifier[] getResourceSpecifiers() {
        return this._resourceSpecifiers;
    }

    @NotThreadSafe
    public static final class Builder {
        private Optional<InetAddress> _address = Optional.empty();
        private int _port;
        private ResourceSpecifier[] _resourceSpecifiers;

        Builder() {
        }

        @Nonnull
        @CheckReturnValue
        public ResourceProvider build() {
            return new ResourceProvider(this._address.orElse(Inet.getLocalHostAddress()), this._port, this._resourceSpecifiers != null ? this._resourceSpecifiers : new ResourceSpecifier[]{});
        }

        @Nonnull
        public Builder importFrom(@Nonnull RLPMessage message) {
            this.setAddress(message.getRemoteAddress());
            this.setPort(message.getRemotePort());
            this.setResourceSpecifier(message.getResourceSpecifiers());
            return this;
        }

        @Nonnull
        public Builder setAddress(@Nonnull Optional<InetAddress> address) {
            this._address = address;
            return this;
        }

        @Nonnull
        public Builder setPort(int port) {
            this._port = port;
            return this;
        }

        public void setResourceSpecifier(@Nonnull ResourceSpecifier[] resourceSpecifiers) {
            this._resourceSpecifiers = resourceSpecifiers;
        }
    }
}

