/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util.rlp;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.logger.Message;
import org.rvpf.base.util.rlp.Datagram;
import org.rvpf.base.util.rlp.Protocol;
import org.rvpf.base.util.rlp.RLPMessages;

@Immutable
public class ResourceSpecifier {
    private final byte[] _identifier;
    private final int _protocol;

    ResourceSpecifier(int protocol, @Nonnull byte[] identifier) {
        this._protocol = protocol;
        this._identifier = identifier;
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ResourceSpecifier otherSpecifier = (ResourceSpecifier)other;
        return otherSpecifier.getProtocol() == this.getProtocol() && Arrays.equals(otherSpecifier.getIdentifier(), this.getIdentifier());
    }

    @Nonnull
    @CheckReturnValue
    public byte[] getIdentifier() {
        return this._identifier;
    }

    @CheckReturnValue
    public int getProtocol() {
        return this._protocol;
    }

    public int hashCode() {
        return Integer.hashCode(this._protocol) ^ Arrays.hashCode(this._identifier);
    }

    @NotThreadSafe
    public static final class Builder {
        private byte[] _identifier;
        private int _protocol;

        Builder() {
        }

        @Nonnull
        @CheckReturnValue
        public ResourceSpecifier build() {
            byte[] identifier = this._identifier != null ? this._identifier : new byte[]{};
            return new ResourceSpecifier(this._protocol, identifier);
        }

        @Nonnull
        public Builder importFrom(@Nonnull Datagram datagram) throws IllegalArgumentException {
            byte[] identifier;
            this.setProtocol(datagram.getNextByte());
            byte[] byArray = identifier = datagram.remainingLength() > 0 ? new byte[datagram.getNextByte() & 0xFF] : null;
            if (identifier == null || datagram.remainingLength() < identifier.length) {
                datagram.reset();
                throw new IllegalArgumentException(Message.format(RLPMessages.DATAGRAM_TOO_SHORT, String.valueOf(datagram.remainingLength())));
            }
            for (int i = 0; i < identifier.length; ++i) {
                identifier[i] = datagram.getNextByte();
            }
            this.setIdentifier(identifier);
            return this;
        }

        @Nonnull
        public Builder setIdentifier(@Nonnull byte[] identifier) {
            this._identifier = identifier;
            return this;
        }

        @Nonnull
        public Builder setIdentifier(@Nonnull String identifier) {
            return this.setIdentifier(identifier.getBytes(StandardCharsets.UTF_8));
        }

        @Nonnull
        public Builder setProtocol(int protocol) {
            this._protocol = protocol;
            return this;
        }

        @Nonnull
        public Builder setProtocol(@Nonnull Protocol protocol) {
            return this.setProtocol(protocol.code());
        }
    }
}

