/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.value;

import java.math.BigInteger;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.rvpf.base.value.Rational;

@Immutable
public final class BigRational
extends Number
implements Comparable<BigRational> {
    private static final long serialVersionUID = 1L;
    private final BigInteger _denominator;
    private final BigInteger _numerator;

    private BigRational(BigInteger numerator, BigInteger denominator) {
        this._numerator = numerator;
        this._denominator = denominator;
    }

    @Nonnull
    @CheckReturnValue
    public static BigRational valueOf(@Nonnull Rational rational) {
        return BigRational.valueOf(BigInteger.valueOf(rational.getNumerator()), BigInteger.valueOf(rational.getDenominator()));
    }

    @Nonnull
    @CheckReturnValue
    public static BigRational valueOf(@Nonnull String string) {
        BigInteger denominator;
        BigInteger numerator;
        int slashIndex = string.indexOf(47);
        if (slashIndex < 0) {
            numerator = new BigInteger(string);
            denominator = BigInteger.ONE;
        } else {
            numerator = new BigInteger(string.substring(0, slashIndex));
            denominator = new BigInteger(string.substring(slashIndex + 1));
        }
        return BigRational.valueOf(numerator, denominator);
    }

    @Nonnull
    @CheckReturnValue
    public static BigRational valueOf(@Nonnull BigInteger numerator, @Nonnull BigInteger denominator) {
        BigInteger gcd;
        if (denominator.signum() == 0) {
            throw new ArithmeticException();
        }
        if (denominator.signum() < 0) {
            numerator = numerator.negate();
            denominator = denominator.negate();
        }
        if ((gcd = numerator.gcd(denominator)).compareTo(BigInteger.ONE) > 0) {
            numerator = numerator.divide(gcd);
            denominator = denominator.divide(gcd);
        }
        return new BigRational(numerator, denominator);
    }

    @Nonnull
    @CheckReturnValue
    public static BigRational valueOf(long numerator, long denominator) {
        return BigRational.valueOf(BigInteger.valueOf(numerator), BigInteger.valueOf(denominator));
    }

    @Nonnull
    @CheckReturnValue
    public BigRational abs() {
        return this._numerator.signum() < 0 ? this.negate() : this;
    }

    @Nonnull
    @CheckReturnValue
    public BigRational add(@Nonnull BigRational other) {
        return BigRational.valueOf(this._numerator.multiply(other._denominator).add(other._numerator.multiply(this._denominator)), this._denominator.multiply(other._denominator));
    }

    @Nonnull
    @CheckReturnValue
    public BigRational add(long integer) {
        return this.add(BigRational.valueOf(integer, 1L));
    }

    @Override
    public int compareTo(BigRational other) {
        return this._numerator.multiply(other._denominator).compareTo(this._denominator.multiply(other._numerator));
    }

    @Nonnull
    @CheckReturnValue
    public BigRational divide(@Nonnull BigRational other) {
        return this.multiply(other.reciprocal());
    }

    @Nonnull
    @CheckReturnValue
    public BigRational divide(long integer) {
        return BigRational.valueOf(this._numerator, this._denominator.multiply(BigInteger.valueOf(integer)));
    }

    @Override
    public double doubleValue() {
        return this._numerator.doubleValue() / this._denominator.doubleValue();
    }

    public boolean equals(Object object) {
        if (object instanceof BigRational) {
            BigRational other = (BigRational)object;
            return this._numerator.equals(other._numerator) && this._denominator.equals(other._denominator);
        }
        return false;
    }

    @Override
    public float floatValue() {
        return this._numerator.floatValue() / this._denominator.floatValue();
    }

    @Nonnull
    @CheckReturnValue
    public BigInteger getDenominator() {
        return this._denominator;
    }

    @Nonnull
    @CheckReturnValue
    public BigInteger getNumerator() {
        return this._numerator;
    }

    public int hashCode() {
        return this._numerator.hashCode() ^ this._denominator.hashCode();
    }

    @Override
    public int intValue() {
        return this._numerator.divide(this._denominator).intValue();
    }

    @Override
    public long longValue() {
        return this._numerator.divide(this._denominator).longValue();
    }

    @Nonnull
    @CheckReturnValue
    public BigRational multiply(@Nonnull BigRational other) {
        return BigRational.valueOf(this._numerator.multiply(other._numerator), this._denominator.multiply(other._denominator));
    }

    @Nonnull
    @CheckReturnValue
    public BigRational multiply(long integer) {
        return BigRational.valueOf(this._numerator.multiply(BigInteger.valueOf(integer)), this._denominator);
    }

    @Nonnull
    @CheckReturnValue
    public BigRational negate() {
        return BigRational.valueOf(this._numerator.negate(), this._denominator);
    }

    @Nonnull
    @CheckReturnValue
    public BigRational reciprocal() {
        return BigRational.valueOf(this._denominator, this._numerator);
    }

    @CheckReturnValue
    public int signum() {
        return this._numerator.signum();
    }

    @Nonnull
    @CheckReturnValue
    public BigRational subtract(@Nonnull BigRational other) {
        return this.add(other.negate());
    }

    @Nonnull
    @CheckReturnValue
    public BigRational subtract(long integer) {
        return this.add(BigRational.valueOf(-integer, 1L));
    }

    public String toString() {
        return this._numerator.toString() + '/' + this._denominator.toString();
    }
}

