/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.value;

import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class Complex
implements Serializable {
    private static final String _POLAR_INDICATOR = "cis";
    private static final Pattern _WHITE_SPACE_PATTERN = Pattern.compile("\\s");
    private static final long serialVersionUID = 1L;

    @Nonnull
    @CheckReturnValue
    public static Cartesian cartesian(double real, double imaginary) {
        return new Cartesian(real, imaginary);
    }

    @Nonnull
    @CheckReturnValue
    public static Polar polar(double magnitude, double angle) {
        return new Polar(magnitude, angle);
    }

    @Nonnull
    @CheckReturnValue
    public static Complex valueOf(String string) {
        return (string = string.toLowerCase(Locale.ROOT)).contains(_POLAR_INDICATOR) ? Complex._polar(string) : Complex._cartesian(string);
    }

    @CheckReturnValue
    public abstract double abs();

    @Nonnull
    @CheckReturnValue
    public abstract Complex acos();

    @Nonnull
    @CheckReturnValue
    public abstract Complex add(@Nonnull Complex var1);

    @CheckReturnValue
    public abstract double angle();

    @CheckReturnValue
    public abstract double argument();

    @Nonnull
    @CheckReturnValue
    public abstract Complex asin();

    @Nonnull
    @CheckReturnValue
    public abstract Complex atan();

    @Nonnull
    @CheckReturnValue
    public abstract Complex conjugate();

    @Nonnull
    @CheckReturnValue
    public abstract Complex cos();

    @Nonnull
    @CheckReturnValue
    public abstract Complex cosh();

    @Nonnull
    @CheckReturnValue
    public abstract Complex divide(@Nonnull Complex var1);

    public abstract boolean equals(Object var1);

    @Nonnull
    @CheckReturnValue
    public abstract Complex exp();

    public abstract int hashCode();

    @CheckReturnValue
    public abstract double imaginary();

    @CheckReturnValue
    public abstract boolean isCartesian();

    @CheckReturnValue
    public abstract boolean isInfinite();

    @CheckReturnValue
    public abstract boolean isNaN();

    @CheckReturnValue
    public abstract boolean isPolar();

    @Nonnull
    @CheckReturnValue
    public abstract Complex log();

    @CheckReturnValue
    public abstract double magnitude();

    @Nonnull
    @CheckReturnValue
    public abstract Complex multiply(@Nonnull Complex var1);

    @Nonnull
    @CheckReturnValue
    public abstract Complex negate();

    @Nonnull
    @CheckReturnValue
    public abstract Complex pow(@Nonnull Complex var1);

    @CheckReturnValue
    public abstract double real();

    @CheckReturnValue
    public abstract int signum();

    @Nonnull
    @CheckReturnValue
    public abstract Complex sin();

    @Nonnull
    @CheckReturnValue
    public abstract Complex sinh();

    @Nonnull
    @CheckReturnValue
    public abstract Complex sqrt();

    @Nonnull
    @CheckReturnValue
    public abstract Complex subtract(@Nonnull Complex var1);

    @Nonnull
    @CheckReturnValue
    public abstract Complex tan();

    @Nonnull
    @CheckReturnValue
    public abstract Complex tanh();

    @Nonnull
    @CheckReturnValue
    public abstract Cartesian toCartesian();

    @Nonnull
    @CheckReturnValue
    public abstract String toHexString();

    @Nonnull
    @CheckReturnValue
    public abstract Polar toPolar();

    public abstract String toString();

    private static Complex _cartesian(String string) {
        double imaginary;
        double real;
        char c1;
        char c;
        int index;
        if ((string = _WHITE_SPACE_PATTERN.matcher(string).replaceAll("")).length() < 1) {
            throw new NumberFormatException();
        }
        int indexLimit = string.length() - 1;
        for (index = 1; index < indexLimit && ((c = string.charAt(index)) != '+' && c != '-' || (c1 = string.charAt(index - 1)) == 'e' || c1 == 'p'); ++index) {
        }
        if (index < indexLimit) {
            if ("ij".indexOf(string.charAt(indexLimit)) < 0) {
                throw new NumberFormatException();
            }
            real = Double.parseDouble(string.substring(0, index));
            imaginary = Double.parseDouble(string.substring(index, indexLimit));
        } else if ("ij".indexOf(string.charAt(indexLimit)) < 0) {
            real = Double.parseDouble(string);
            imaginary = 0.0;
        } else {
            real = 0.0;
            imaginary = Double.parseDouble(string.substring(0, indexLimit));
        }
        return Complex.cartesian(real, imaginary);
    }

    private static Complex _polar(String string) {
        int cis = string.indexOf(_POLAR_INDICATOR);
        String magnitude = string.substring(0, cis).trim();
        String angle = string.substring(cis + _POLAR_INDICATOR.length()).trim();
        return new Polar(magnitude.length() > 0 ? Double.parseDouble(magnitude) : 0.0, angle.length() > 0 ? Double.parseDouble(angle) : 0.0);
    }

    @Immutable
    public static final class Polar
    extends Complex {
        private static final double _PI_2 = 1.5707963267948966;
        private static final double _PI2 = Math.PI * 2;
        private static final long serialVersionUID = 1L;
        private final double _angle;
        private final double _magnitude;

        Polar(double magnitude, double angle) {
            if (magnitude == 0.0) {
                angle = 0.0;
            } else {
                if (magnitude < 0.0) {
                    angle += Math.PI;
                    magnitude = -magnitude;
                }
                if (Math.abs(angle %= Math.PI * 2) > Math.PI) {
                    angle -= Math.signum(angle) * (Math.PI * 2);
                }
            }
            this._magnitude = magnitude;
            this._angle = angle;
        }

        @Override
        public double abs() {
            return this.magnitude();
        }

        @Override
        public Complex acos() {
            return this.toCartesian().acos();
        }

        @Override
        public Complex add(Complex complex) {
            return this.toCartesian().add(complex);
        }

        @Override
        public double angle() {
            return this._angle;
        }

        @Override
        public double argument() {
            return this.angle();
        }

        @Override
        public Complex asin() {
            return this.toCartesian().asin();
        }

        @Override
        public Complex atan() {
            return this.toCartesian().atan();
        }

        @Override
        public Complex conjugate() {
            return new Polar(this._magnitude, -this._angle);
        }

        @Override
        public Complex cos() {
            return this.toCartesian().cos();
        }

        @Override
        public Complex cosh() {
            return this.toCartesian().cosh();
        }

        @Override
        public Complex divide(Complex complex) {
            Polar polar = complex.toPolar();
            return new Polar(this._magnitude / polar._magnitude, this._angle - polar._angle);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof Polar) {
                Polar other = (Polar)object;
                return Double.doubleToLongBits(this._magnitude) == Double.doubleToLongBits(other._magnitude) && Double.doubleToLongBits(this._angle) == Double.doubleToLongBits(other._angle);
            }
            return false;
        }

        @Override
        public Complex exp() {
            return this.toCartesian().exp();
        }

        @Override
        public int hashCode() {
            long bits = Double.doubleToLongBits(this._magnitude) ^ Double.doubleToLongBits(this._angle);
            return (int)(bits ^ bits >>> 32);
        }

        @Override
        public double imaginary() {
            return this._magnitude * Math.sin(this._angle);
        }

        @Override
        public boolean isCartesian() {
            return false;
        }

        @Override
        public boolean isInfinite() {
            return !this.isNaN() && (Double.isInfinite(this._magnitude) || Double.isInfinite(this._angle));
        }

        @Override
        public boolean isNaN() {
            return Double.isNaN(this._magnitude) || Double.isNaN(this._angle);
        }

        @Override
        public boolean isPolar() {
            return true;
        }

        @Override
        public Complex log() {
            return new Cartesian(Math.log(this._magnitude), this._angle);
        }

        @Override
        public double magnitude() {
            return this._magnitude;
        }

        @Override
        public Complex multiply(Complex complex) {
            Polar polar = complex.toPolar();
            return new Polar(this._magnitude * polar._magnitude, this._angle + polar._angle);
        }

        @Override
        public Complex negate() {
            return new Polar(-this._magnitude, this._angle);
        }

        @Override
        public Complex pow(Complex complex) {
            return this.toCartesian().pow(complex);
        }

        @Override
        public double real() {
            return this._magnitude * Math.cos(this._angle);
        }

        @Override
        public int signum() {
            int signum = -((int)Math.signum(Math.abs(this._angle) - 1.5707963267948966));
            return signum != 0 ? signum : (int)Math.signum(this._angle);
        }

        @Override
        public Complex sin() {
            return this.toCartesian().sin();
        }

        @Override
        public Complex sinh() {
            return this.toCartesian().sinh();
        }

        @Override
        public Complex sqrt() {
            return this.toCartesian().sqrt();
        }

        @Override
        public Complex subtract(Complex complex) {
            return this.toCartesian().subtract(complex);
        }

        @Override
        public Complex tan() {
            return this.toCartesian().tan();
        }

        @Override
        public Complex tanh() {
            return this.toCartesian().tanh();
        }

        @Override
        public Cartesian toCartesian() {
            return new Cartesian(this._magnitude * Math.cos(this._angle), this._magnitude * Math.sin(this._angle));
        }

        @Override
        public String toHexString() {
            StringBuilder stringBuilder = new StringBuilder(Double.toHexString(this._magnitude));
            stringBuilder.append(" cis ");
            stringBuilder.append(Double.toHexString(this._angle));
            return stringBuilder.toString();
        }

        @Override
        public Polar toPolar() {
            return this;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(Double.toString(this._magnitude));
            stringBuilder.append(Complex._POLAR_INDICATOR);
            stringBuilder.append(Double.toString(this._angle));
            return stringBuilder.toString();
        }
    }

    @Immutable
    public static final class Cartesian
    extends Complex {
        public static final Cartesian I = new Cartesian(0.0, 1.0);
        public static final Cartesian ONE = new Cartesian(1.0, 0.0);
        public static final Cartesian TWO = new Cartesian(2.0, 0.0);
        private static final long serialVersionUID = 1L;
        private final double _imaginary;
        private final double _real;

        Cartesian(double real, double imaginary) {
            this._real = real;
            this._imaginary = imaginary;
        }

        @Override
        public double abs() {
            return Math.hypot(this._real, this._imaginary);
        }

        @Override
        public Complex acos() {
            return this.add(I.multiply(this._sqrt1z())).log().multiply(I.negate());
        }

        @Override
        public Complex add(Complex complex) {
            Cartesian cartesian = complex.toCartesian();
            return new Cartesian(this._real + cartesian._real, this._imaginary + cartesian._imaginary);
        }

        @Override
        public double angle() {
            return this.argument();
        }

        @Override
        public double argument() {
            return Math.atan2(this._imaginary, this._real);
        }

        @Override
        public Complex asin() {
            return I.negate().multiply(this._sqrt1z().add(this.multiply(I)).log());
        }

        @Override
        public Complex atan() {
            return I.divide(TWO).multiply(this.add(I).divide(this.negate().add(I)).log());
        }

        @Override
        public Complex conjugate() {
            return new Cartesian(this._real, -this._imaginary);
        }

        @Override
        public Complex cos() {
            return new Cartesian(Math.cos(this._real) * Math.cosh(this._imaginary), Math.sin(this._real) * Math.sinh(this._imaginary));
        }

        @Override
        public Complex cosh() {
            return new Cartesian(Math.cosh(this._real) * Math.cos(this._imaginary), Math.sinh(this._real) * Math.sin(this._imaginary));
        }

        @Override
        public Complex divide(Complex complex) {
            Cartesian cartesian = complex.toCartesian();
            double divisor = cartesian._real * cartesian._real + cartesian._imaginary * cartesian._imaginary;
            double real = (this._real * cartesian._real + this._imaginary * cartesian._imaginary) / divisor;
            double imaginary = (this._imaginary * cartesian._real - this._real * cartesian._imaginary) / divisor;
            return new Cartesian(real, imaginary);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof Cartesian) {
                Cartesian other = (Cartesian)object;
                return Double.doubleToLongBits(this._real) == Double.doubleToLongBits(other._real) && Double.doubleToLongBits(this._imaginary) == Double.doubleToLongBits(other._imaginary);
            }
            return false;
        }

        @Override
        public Complex exp() {
            double expReal = Math.exp(this._real);
            return new Cartesian(expReal * Math.cos(this._imaginary), expReal * Math.sin(this._imaginary));
        }

        @Override
        public int hashCode() {
            long bits = Double.doubleToLongBits(this._real) ^ Double.doubleToLongBits(this._imaginary);
            return (int)(bits ^ bits >>> 32);
        }

        @Override
        public double imaginary() {
            return this._imaginary;
        }

        @Override
        public boolean isCartesian() {
            return true;
        }

        @Override
        public boolean isInfinite() {
            return !this.isNaN() && (Double.isInfinite(this._real) || Double.isInfinite(this._imaginary));
        }

        @Override
        public boolean isNaN() {
            return Double.isNaN(this._real) || Double.isNaN(this._imaginary);
        }

        @Override
        public boolean isPolar() {
            return false;
        }

        @Override
        public Complex log() {
            return new Cartesian(Math.log(this.abs()), this.argument());
        }

        @Override
        public double magnitude() {
            return this.abs();
        }

        @Override
        public Complex multiply(Complex complex) {
            Cartesian cartesian = complex.toCartesian();
            return new Cartesian(this._real * cartesian._real - this._imaginary * cartesian._imaginary, this._imaginary * cartesian._real + this._real * cartesian._imaginary);
        }

        @Override
        public Cartesian negate() {
            return new Cartesian(-this._real, -this._imaginary);
        }

        @Override
        public Complex pow(Complex complex) {
            return this.log().multiply(complex).exp();
        }

        @Override
        public double real() {
            return this._real;
        }

        @Override
        public int signum() {
            int signum = (int)Math.signum(this._real);
            return signum != 0 ? signum : (int)Math.signum(this._imaginary);
        }

        @Override
        public Complex sin() {
            return new Cartesian(Math.sin(this._real) * Math.cosh(this._imaginary), Math.cos(this._real) * Math.sinh(this._imaginary));
        }

        @Override
        public Complex sinh() {
            return new Cartesian(Math.sinh(this._real) * Math.cos(this._imaginary), Math.cosh(this._real) * Math.sin(this._imaginary));
        }

        @Override
        public Complex sqrt() {
            double t2 = Math.sqrt(Math.abs(this._real) + this.abs());
            double t = t2 / 2.0;
            return this._real >= 0.0 ? new Cartesian(t, this._imaginary / t2) : new Cartesian(Math.abs(this._imaginary) / t2, Math.signum(this._imaginary) * t);
        }

        @Override
        public Complex subtract(Complex complex) {
            Cartesian cartesian = complex.toCartesian();
            return new Cartesian(this._real - cartesian._real, this._imaginary - cartesian._imaginary);
        }

        @Override
        public Complex tan() {
            double real2 = this._real * 2.0;
            double imaginary2 = this._imaginary * 2.0;
            double divisor = Math.cos(real2) + Math.cosh(imaginary2);
            return new Cartesian(Math.sin(real2) / divisor, Math.sinh(imaginary2) / divisor);
        }

        @Override
        public Complex tanh() {
            double real2 = this._real * 2.0;
            double imaginary2 = this._imaginary * 2.0;
            double divisor = Math.cosh(real2) + Math.cos(imaginary2);
            return new Cartesian(Math.sinh(real2) / divisor, Math.sin(imaginary2) / divisor);
        }

        @Override
        public Cartesian toCartesian() {
            return this;
        }

        @Override
        public String toHexString() {
            StringBuilder stringBuilder = new StringBuilder(Double.toHexString(this._real));
            stringBuilder.append(this._imaginary >= 0.0 ? " + " : " - ");
            stringBuilder.append(Double.toHexString(Math.abs(this._imaginary)));
            stringBuilder.append('j');
            return stringBuilder.toString();
        }

        @Override
        public Polar toPolar() {
            return new Polar(this.magnitude(), this.angle());
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(Double.toString(this._real));
            stringBuilder.append(this._imaginary >= 0.0 ? (char)'+' : '-');
            stringBuilder.append(Double.toString(Math.abs(this._imaginary)));
            stringBuilder.append('j');
            return stringBuilder.toString();
        }

        private Complex _sqrt1z() {
            return ONE.subtract(this.multiply(this)).sqrt();
        }
    }
}

