/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.value;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.rvpf.base.value.Container;

public final class Dict
implements Container,
Map<String, Serializable> {
    private static final long serialVersionUID = 1L;
    private LinkedHashMap<String, Serializable> _entries;
    private transient Map<String, Serializable> _frozen;

    public Dict() {
        this._entries = new LinkedHashMap();
    }

    public Dict(int capacity) {
        this._entries = new LinkedHashMap(capacity);
    }

    @Override
    public void clear() {
        this._getEntries().clear();
    }

    public Dict clone() {
        Dict clone;
        try {
            clone = (Dict)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError(exception);
        }
        clone._entries = (LinkedHashMap)this._entries.clone();
        clone._frozen = null;
        return clone;
    }

    @Override
    public boolean containsKey(Object key) {
        return this._entries.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._entries.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Serializable>> entrySet() {
        return this._getEntries().entrySet();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Dict)) {
            return false;
        }
        return this._entries.equals(((Dict)object)._entries);
    }

    @Override
    public void freeze() {
        if (this._frozen == null) {
            this._frozen = Collections.unmodifiableMap(this._entries);
        }
    }

    @Override
    public Serializable get(Object key) {
        return this._entries.get(key);
    }

    @Override
    public int hashCode() {
        return this._entries.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this._entries.isEmpty();
    }

    @Override
    public boolean isFrozen() {
        return this._frozen != null;
    }

    @Override
    public Set<String> keySet() {
        return this._getEntries().keySet();
    }

    @Override
    public Serializable put(String key, Serializable value) {
        return this._getEntries().put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Serializable> map) {
        this._getEntries().putAll(map);
    }

    @Override
    public Serializable remove(Object key) {
        return this._getEntries().remove(key);
    }

    @Override
    public int size() {
        return this._entries.size();
    }

    public String toString() {
        return this._entries.toString();
    }

    @Override
    public Collection<Serializable> values() {
        return this._getEntries().values();
    }

    private Map<String, Serializable> _getEntries() {
        Map<String, Serializable> frozen = this._frozen;
        return frozen != null ? frozen : this._entries;
    }

    private Object readResolve() {
        this.freeze();
        return this;
    }
}

