/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.value;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.Content;
import org.rvpf.base.DateTime;
import org.rvpf.base.Point;
import org.rvpf.base.value.PointValue;

@NotThreadSafe
public class NormalizedValue
extends PointValue {
    private static final long serialVersionUID = 1L;

    public NormalizedValue() {
    }

    public NormalizedValue(@Nonnull PointValue pointValue) {
        super(pointValue);
    }

    public NormalizedValue(@Nonnull Point point, @Nonnull Optional<DateTime> stamp, @Nullable Serializable state, @Nullable Serializable value) {
        super(point, stamp, state, value);
    }

    @Override
    public NormalizedValue copy() {
        return new NormalizedValue(this);
    }

    @Override
    public PointValue denormalized() {
        PointValue denormalized = new PointValue(this);
        if (this.getValue() != null) {
            Optional<Content> content = this.getPoint().get().getContent();
            if (!content.isPresent()) {
                return new PointValue(this);
            }
            denormalized.setValue(content.get().denormalize(this));
        }
        return denormalized;
    }

    @Override
    public final boolean isNormalized() {
        return true;
    }

    @Override
    public final NormalizedValue normalized() {
        return this;
    }

    static class Null
    extends NormalizedValue {
        public Null(@Nonnull PointValue pointValue) {
            super(pointValue);
            this.setFrozen();
        }

        @Override
        public PointValue denormalized() {
            return new PointValue.Null(this);
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            return Objects.equals(this.getPointUUID(), ((Null)object).getPointUUID());
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.getPointUUID());
        }

        @Override
        public boolean sameValueAs(PointValue pointValue) {
            return false;
        }
    }
}

