/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.value;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.Content;
import org.rvpf.base.DateTime;
import org.rvpf.base.Point;
import org.rvpf.base.Points;
import org.rvpf.base.UUID;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.store.Store;
import org.rvpf.base.store.StoreAccessException;
import org.rvpf.base.tool.Externalizer;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.Mappable;
import org.rvpf.base.value.Container;
import org.rvpf.base.value.NormalizedValue;
import org.rvpf.base.value.State;
import org.rvpf.base.value.Tuple;
import org.rvpf.base.xml.streamer.Streamer;

@NotThreadSafe
public class PointValue
implements Externalizable,
Mappable,
Streamer.Validated {
    public static final PointValue NULL = new Null();
    public static final String POINT_FIELD = "point";
    public static final String STAMP_FIELD = "stamp";
    public static final String STATE_FIELD = "state";
    public static final String UUID_FIELD = "uuid";
    public static final String VALUE_FIELD = "value";
    private static final long serialVersionUID = 1L;
    private transient boolean _frozen;
    private transient Point _point;
    private UUID _pointUUID;
    private DateTime _stamp;
    private Serializable _state;
    private Serializable _value;

    public PointValue() {
    }

    public PointValue(@Nonnull PointValue other) {
        this._point = other._point;
        this._pointUUID = other._pointUUID;
        Require.success(this._point != null || this._pointUUID != null);
        this._stamp = other._stamp;
        this._state = other._state;
        this._value = other._value;
    }

    public PointValue(@Nonnull Point point, @Nonnull Optional<DateTime> stamp, @Nullable Serializable state, @Nullable Serializable value) {
        Require.notNull(point);
        this._point = point;
        this._pointUUID = point.getUUID().get();
        Require.success(this._pointUUID != null || point instanceof Point.Named, (Object)"Bad point identity");
        this._stamp = stamp.orElse(null);
        this._state = state;
        this._value = value;
    }

    public PointValue(@Nonnull String point, @Nonnull Optional<DateTime> stamp, @Nullable Serializable state, @Nullable Serializable value) {
        Require.notNull(point);
        point = point.trim();
        if (!point.isEmpty()) {
            if (UUID.isUUID(point)) {
                this._pointUUID = UUID.fromString(point).get();
            } else {
                this._point = new Point.Named(point);
            }
        }
        this._stamp = stamp.orElse(null);
        this._state = state;
        this._value = value;
    }

    public PointValue(@Nonnull UUID uuid, @Nonnull Optional<DateTime> stamp, @Nullable Serializable state, @Nullable Serializable value) {
        Require.notNull(uuid);
        this._pointUUID = uuid;
        this._stamp = stamp.orElse(null);
        this._state = state;
        this._value = value;
    }

    public final void clearStamp() {
        this.checkNotFrozen();
        this._stamp = null;
    }

    @CheckReturnValue
    public final boolean confirm(boolean confirmValue) throws InterruptedException, StoreAccessException {
        Point point = this.getPoint().get();
        Store store = point.getStore().get();
        return store.confirm(this, confirmValue);
    }

    @Nonnull
    @CheckReturnValue
    public PointValue copy() {
        return new PointValue(this);
    }

    public void copyValueFrom(@Nonnull PointValue pointValue) {
        this.setState(pointValue.getState());
        this.setValue(pointValue.getValue());
    }

    @Nonnull
    @CheckReturnValue
    public final PointValue decoded() {
        PointValue decoded;
        Optional<Content> content = this.getPoint().get().getContent();
        if (!content.isPresent()) {
            return this;
        }
        Serializable value = content.get().decode(this);
        if (value != this.getValue()) {
            decoded = this.copy();
            decoded.setValue(value);
        } else {
            decoded = this;
        }
        return decoded;
    }

    @Nonnull
    @CheckReturnValue
    public PointValue denormalized() {
        return this;
    }

    @Nonnull
    @CheckReturnValue
    public final PointValue encoded() {
        PointValue encoded;
        PointValue denormalized = this.denormalized();
        Optional<Content> content = this.getPoint().get().getContent();
        if (!content.isPresent()) {
            return this;
        }
        Serializable value = content.get().encode(denormalized);
        if (value != denormalized.getValue()) {
            encoded = denormalized.copy();
            encoded.setValue(value);
        } else {
            encoded = denormalized;
        }
        return encoded;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PointValue)) {
            return false;
        }
        PointValue other = (PointValue)object;
        if (this._pointUUID != null) {
            if (!this._pointUUID.equals(other._pointUUID)) {
                return false;
            }
        } else {
            Require.success(this._point != null && this._point.getName().isPresent(), (Object)"Point not identified");
            if (other._point == null) {
                return false;
            }
            if (!this._point.getName().equals(other._point.getName())) {
                return false;
            }
        }
        Require.notNull(this._stamp, "Point not stamped");
        return this._stamp.equals(other._stamp);
    }

    public final void freeze() {
        if (!this._frozen) {
            Require.success(this._point != null || this._pointUUID != null, (Object)"No point");
            Require.notNull(this._stamp, "No stamp");
            if (this._state instanceof Container) {
                ((Container)this._state).freeze();
            }
            if (this._value instanceof Container) {
                ((Container)this._value).freeze();
            }
            this._frozen = true;
        }
    }

    @Nonnull
    @CheckReturnValue
    public PointValue frozen() {
        PointValue frozen;
        if (this.isFrozen()) {
            frozen = this;
        } else {
            frozen = this.copy();
            frozen.freeze();
        }
        return frozen;
    }

    @Nullable
    @CheckReturnValue
    public final Point getNullablePoint() {
        return this._pointUUID != null ? this._point : null;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<Point> getPoint() {
        return this._pointUUID != null ? Optional.ofNullable(this._point) : Optional.empty();
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<String> getPointName() {
        return this._point != null ? this._point.getName() : Optional.empty();
    }

    @Nonnull
    @CheckReturnValue
    public final UUID getPointUUID() {
        return Require.notNull(this._pointUUID);
    }

    @Nonnull
    @CheckReturnValue
    public final DateTime getStamp() {
        return Require.notNull(this._stamp);
    }

    @Nullable
    @CheckReturnValue
    public final Serializable getState() {
        return this._state;
    }

    @Nullable
    @CheckReturnValue
    public final Serializable getValue() {
        return this._value;
    }

    @CheckReturnValue
    public boolean hasPointUUID() {
        return this._pointUUID != null;
    }

    @CheckReturnValue
    public boolean hasStamp() {
        return this._stamp != null;
    }

    public int hashCode() {
        int hash = 0;
        if (this._pointUUID != null) {
            hash ^= this._pointUUID.hashCode();
        } else {
            String pointName = this._point != null ? (String)this._point.getName().orElse(null) : null;
            hash ^= Require.notNull(pointName, "Point not identified").hashCode();
        }
        if (this._stamp != null) {
            hash ^= this._stamp.hashCode();
        } else if (!(this instanceof Null)) {
            Require.failure("Point not stamped");
        }
        return hash;
    }

    @CheckReturnValue
    public boolean isAbsent() {
        return this._stamp == null;
    }

    @CheckReturnValue
    public final boolean isCacheable() {
        return !this.isSynthesized() && !this._point.isVolatile();
    }

    @CheckReturnValue
    public boolean isDeleted() {
        return false;
    }

    @CheckReturnValue
    public boolean isExtrapolated() {
        return false;
    }

    @CheckReturnValue
    public final boolean isFrozen() {
        return this._frozen;
    }

    @CheckReturnValue
    public boolean isInterpolated() {
        return false;
    }

    @CheckReturnValue
    public boolean isNormalized() {
        return false;
    }

    @CheckReturnValue
    public final boolean isPresent() {
        return !this.isAbsent();
    }

    @CheckReturnValue
    public boolean isSynthesized() {
        return false;
    }

    @Nonnull
    @CheckReturnValue
    public PointValue morph(@Nonnull Optional<UUID> uuid) {
        if (Objects.equals(this._pointUUID, uuid.orElse(null))) {
            return this;
        }
        PointValue clone = this.copy();
        clone._pointUUID = uuid.orElse(null);
        clone._point = null;
        return clone;
    }

    @Nonnull
    @CheckReturnValue
    public final PointValue morph(@Nonnull Optional<Point> point, @Nonnull Optional<DateTime> stamp) {
        PointValue clone;
        if (point.isPresent()) {
            clone = this.copy();
            clone._point = point.get();
            clone._pointUUID = point.get().getUUID().get();
        } else {
            clone = null;
        }
        if (stamp.isPresent() && !stamp.get().equals(this._stamp)) {
            if (this._stamp == null && !this._frozen) {
                this._stamp = stamp.get();
            } else {
                if (clone == null) {
                    clone = this.copy();
                }
                clone._stamp = stamp.get();
            }
        }
        return clone != null ? clone : this;
    }

    @Nonnull
    @CheckReturnValue
    public NormalizedValue normalized() {
        Point point = this.getPoint().get();
        Optional<Content> content = point.getContent();
        if (!content.isPresent()) {
            return new NormalizedValue(this);
        }
        Serializable value = content.get().decode(this);
        NormalizedValue normalized = new NormalizedValue(point, Optional.of(this.getStamp()), this.getState(), value);
        if (value != null) {
            normalized.setValue(content.get().normalize(normalized));
        }
        return normalized;
    }

    @Nonnull
    @CheckReturnValue
    public final String pointString() {
        if (this._point != null) {
            return this._point.toString();
        }
        if (this._pointUUID != null) {
            return this._pointUUID.toString();
        }
        return "";
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException {
        Optional<String> pointName;
        this._pointUUID = UUID.readExternal(input).orElse(null);
        if (this._pointUUID == null && (pointName = Externalizer.readString(input)).isPresent()) {
            this._point = new Point.Named(pointName.get());
        }
        this._stamp = DateTime.readExternal(input).orElse(null);
        this._state = Externalizer.readSerializable(input);
        this._value = Externalizer.readSerializable(input);
        this.setFrozen();
    }

    @Override
    public void readMap(Map<String, Serializable> map) {
        String uuidString = (String)((Object)map.get(UUID_FIELD));
        if (uuidString != null) {
            this._pointUUID = UUID.fromString(uuidString).get();
        } else {
            String pointString = (String)((Object)map.get(POINT_FIELD));
            if (pointString != null) {
                if (UUID.isUUID(pointString)) {
                    this._pointUUID = UUID.fromString(pointString).get();
                } else {
                    this._point = new Point.Named(pointString);
                }
            }
        }
        this._stamp = DateTime.fromString(Optional.ofNullable((String)((Object)map.get(STAMP_FIELD)))).orElse(null);
        this._state = map.get(STATE_FIELD);
        this._value = map.get(VALUE_FIELD);
        this.setFrozen();
    }

    @Nonnull
    @CheckReturnValue
    public final PointValue reset() {
        PointValue clone = this.copy();
        if (this.getClass() != Null.class && !(this._point instanceof Point.Named)) {
            if (this._pointUUID == null) {
                if (this._point != null) {
                    clone._pointUUID = this._point.getUUID().get();
                }
                Require.notNull(clone._pointUUID, "Can't reset: point UUID not specified");
            }
            clone._point = null;
        }
        clone.freeze();
        return clone;
    }

    @Nonnull
    @CheckReturnValue
    public final PointValue restore(@Nullable Point point) {
        if (point == null || point.isDropped()) {
            return this;
        }
        Optional<UUID> pointUUID = point.getUUID();
        DateTime version = this.getVersion();
        if (this._pointUUID == null) {
            if (this._point == null) {
                this._pointUUID = pointUUID.orElse(null);
                this._point = point;
                return this;
            }
            if (point instanceof Point.Named) {
                Optional<String> pointName = point.getName();
                Require.success(pointName.get().equalsIgnoreCase(this._point.getName().orElse(null)), (Object)("'" + pointName + "' != '" + this._point.getName() + "'"));
                return this;
            }
            Require.present(pointUUID, "Point UUID is missing");
            PointValue pointValue = this.copy();
            pointValue._pointUUID = pointUUID.orElse(null);
            pointValue._point = point;
            pointValue.setVersion(version);
            return pointValue;
        }
        Require.success(!pointUUID.isPresent() || pointUUID.get().equals(this._pointUUID), (Object)("'" + pointUUID + "' != '" + this._pointUUID + "'"));
        PointValue pointValue = this._point == null ? this : this.copy();
        pointValue._point = point;
        pointValue.setVersion(version);
        return pointValue;
    }

    @Nonnull
    @CheckReturnValue
    public final PointValue restore(@Nonnull Points points) {
        PointValue pointValue = this._pointUUID == null ? (this._point != null ? this.restore((Point)points.getPointByName(this._point.getName().orElse(null)).orElse(null)) : this) : this.restore((Point)points.getPointByUUID(this._pointUUID).orElse(null));
        return pointValue;
    }

    @CheckReturnValue
    public boolean sameValueAs(@Nonnull PointValue pointValue) {
        boolean same;
        if (this._value != null) {
            same = this._value.equals(pointValue._value);
        } else {
            boolean bl = same = pointValue._value == null;
        }
        if (same) {
            same = this._state != null ? this._state.equals(pointValue._state) : pointValue._state == null;
        }
        return same;
    }

    public final void setPointName(@Nonnull String name) {
        Require.equal(null, this._point, (Object)"Point is already specified");
        this._point = new Point.Named(name);
    }

    public final void setPointUUID(@Nonnull UUID uuid) {
        this.checkNotFrozen();
        Require.equal(null, this._pointUUID, (Object)"Point UUID already set");
        Require.equal(null, this._point, (Object)"Point name already set");
        this._pointUUID = Require.notNull(uuid);
    }

    public final void setStamp(@Nonnull DateTime stamp) {
        this.checkNotFrozen();
        Require.equal(null, this._stamp, (Object)"Stamp already set");
        this._stamp = Require.notNull(stamp);
    }

    public final void setState(@Nullable Serializable state) {
        this.checkNotFrozen();
        this._state = state;
    }

    public final void setValue(@Nullable Serializable value) {
        this.checkNotFrozen();
        this._value = value;
    }

    @Nonnull
    @CheckReturnValue
    public PointValue thawed() {
        return this.isFrozen() ? this.copy() : this;
    }

    @Nullable
    @CheckReturnValue
    public Double toDouble() {
        if (this._value instanceof Double) {
            return (Double)this._value;
        }
        if (this._value instanceof Number) {
            return ((Number)this._value).doubleValue();
        }
        if (this._value instanceof String) {
            try {
                return Double.valueOf((String)((Object)this._value));
            }
            catch (NumberFormatException exception) {
                this.getThisLogger().warn(BaseMessages.BAD_VALUE_NULLED, this._value);
                return null;
            }
        }
        if (this._value instanceof Boolean) {
            return (Boolean)this._value != false ? 1.0 : 0.0;
        }
        return null;
    }

    @Nullable
    @CheckReturnValue
    public Long toLong() {
        if (this._value instanceof Long) {
            return (Long)this._value;
        }
        if (this._value instanceof Number) {
            return ((Number)this._value).longValue();
        }
        if (this._value instanceof String) {
            try {
                return Long.decode((String)((Object)this._value));
            }
            catch (NumberFormatException exception) {
                this.getThisLogger().warn(BaseMessages.BAD_VALUE_NULLED, this._value);
                return null;
            }
        }
        if (this._value instanceof Boolean) {
            return (Boolean)this._value != false ? 1L : 0L;
        }
        return null;
    }

    public final String toString() {
        return this.toString(DateTime.defaultContext());
    }

    @Nonnull
    @CheckReturnValue
    public final String toString(@Nonnull DateTime.Context dateTimeContext) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("'");
        stringBuilder.append(this.pointString());
        stringBuilder.append("'");
        stringBuilder.append(' ');
        stringBuilder.append(this.getStampString(dateTimeContext));
        if (this.isDeleted()) {
            stringBuilder.append(" (deleted)");
        } else {
            if (this.isSynthesized()) {
                stringBuilder.append(" (");
                stringBuilder.append(this.getSynthesizedString());
                stringBuilder.append(')');
            }
            if (this._state != null) {
                stringBuilder.append(" [");
                stringBuilder.append(PointValue._valueString(this._state));
                stringBuilder.append(']');
            }
            stringBuilder.append(' ');
            stringBuilder.append(this.valueString());
        }
        return stringBuilder.toString();
    }

    @CheckReturnValue
    public final boolean updateStore() throws InterruptedException, StoreAccessException {
        Store store = this.getPoint().get().getStore().get();
        store.addUpdate(this);
        return store.sendUpdates();
    }

    @Override
    public boolean validate() {
        boolean valid = true;
        if (this._stamp != null) {
            if (this._pointUUID == null && (this._point == null || !this._point.getName().isPresent() || this._point.getName().get().trim().isEmpty())) {
                this.getThisLogger().error(BaseMessages.NO_POINT, new Object[0]);
                valid = false;
            }
        } else if (this._pointUUID != null || this._point != null || this._state != null || this._value != null) {
            this.getThisLogger().error(BaseMessages.NO_STAMP, new Object[0]);
            valid = false;
        }
        return valid;
    }

    @Nonnull
    @CheckReturnValue
    public String valueString() {
        return PointValue._valueString(this._value);
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        this.freeze();
        UUID.writeExternal(Optional.ofNullable(this._pointUUID), output);
        if (this._pointUUID == null) {
            Externalizer.writeString(this._point != null ? this._point.getName() : Optional.empty(), output);
        }
        DateTime.writeExternal(Optional.ofNullable(this._stamp), output);
        Externalizer.writeSerializable(this._state, output);
        Externalizer.writeSerializable(this._value, output);
    }

    @Override
    public void writeMap(Map<String, Serializable> map) {
        String point;
        map.put("", null);
        UUID uuid = this._pointUUID != null ? this._pointUUID : (this._point != null ? (UUID)this._point.getUUID().orElse(null) : null);
        String string = point = this._point != null ? this._point.getName().get() : null;
        if (point != null) {
            map.put(POINT_FIELD, (Serializable)((Object)point));
        } else if (uuid != null) {
            map.put(POINT_FIELD, (Serializable)((Object)uuid.toString()));
        }
        if (point != null && uuid != null) {
            map.put(UUID_FIELD, (Serializable)((Object)uuid.toString()));
        }
        if (this._stamp != null) {
            map.put(STAMP_FIELD, (Serializable)((Object)this._stamp.toString()));
        }
        map.put(SERIALIZABLE_MODE, null);
        map.put(STATE_FIELD, this._state);
        map.put(VALUE_FIELD, this._value);
        this.freeze();
    }

    protected final void checkNotFrozen() {
        Require.success(!this._frozen, (Object)BaseMessages.FROZEN);
    }

    @Nonnull
    @CheckReturnValue
    protected String getStampString(@Nonnull DateTime.Context dateTimeContext) {
        return this._stamp != null ? dateTimeContext.toString(this._stamp) : "null";
    }

    @Nonnull
    @CheckReturnValue
    protected String getSynthesizedString() {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    @CheckReturnValue
    protected final Logger getThisLogger() {
        return Logger.getInstance(this.getClass());
    }

    @CheckReturnValue
    protected DateTime getVersion() {
        return null;
    }

    protected final void setFrozen() {
        this._frozen = true;
    }

    protected void setVersion(DateTime version) {
    }

    private static String _valueString(Serializable value) {
        String valueString;
        if (value == null) {
            valueString = "null";
        } else if (value instanceof State) {
            valueString = value.toString();
        } else if (value instanceof Number || value instanceof String || value instanceof Boolean) {
            valueString = "\"" + value.toString() + "\"";
        } else if (value instanceof Tuple) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean first = true;
            stringBuilder.append('(');
            for (Serializable childValue : (Tuple)value) {
                if (!first) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(PointValue._valueString(childValue));
                first = false;
            }
            stringBuilder.append(')');
            valueString = stringBuilder.toString();
        } else {
            valueString = value.getClass().getName();
        }
        return valueString;
    }

    public static class Null
    extends PointValue {
        public Null() {
            this.setFrozen();
        }

        public Null(@Nonnull PointValue pointValue) {
            super(pointValue);
            this.setFrozen();
        }

        @Override
        public Null copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            return Objects.equals(this.getPointUUID(), ((Null)object).getPointUUID());
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.getPointUUID());
        }

        @Override
        public NormalizedValue normalized() {
            return new NormalizedValue.Null(this);
        }

        @Override
        public boolean sameValueAs(PointValue pointValue) {
            return false;
        }

        private Object readResolve() {
            return this.hasPointUUID() ? this : NULL;
        }
    }
}

