/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.value;

import java.math.BigInteger;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.rvpf.base.value.BigRational;

@Immutable
public final class Rational
extends Number
implements Comparable<Rational> {
    private static final long serialVersionUID = 1L;
    private final long _denominator;
    private final long _numerator;

    private Rational(long numerator, long denominator) {
        this._numerator = numerator;
        this._denominator = denominator;
    }

    @Nonnull
    @CheckReturnValue
    public static Rational valueOf(@Nonnull String string) {
        long denominator;
        long numerator;
        int slashIndex = string.indexOf(47);
        if (slashIndex < 0) {
            numerator = Long.parseLong(string);
            denominator = 1L;
        } else {
            numerator = Long.parseLong(string.substring(0, slashIndex).trim());
            denominator = Long.parseLong(string.substring(slashIndex + 1).trim());
        }
        return Rational.valueOf(numerator, denominator);
    }

    @Nonnull
    @CheckReturnValue
    public static Rational valueOf(long numerator, long denominator) {
        long gcd;
        if (denominator == 0L) {
            throw new ArithmeticException();
        }
        if (numerator == Long.MIN_VALUE) {
            throw new ArithmeticException();
        }
        if (denominator < 0L) {
            if (denominator == Long.MIN_VALUE) {
                throw new ArithmeticException();
            }
            numerator = -numerator;
            denominator = -denominator;
        }
        if ((gcd = Rational._gcd(numerator, denominator)) > 1L) {
            numerator /= gcd;
            denominator /= gcd;
        }
        return new Rational(numerator, denominator);
    }

    @Nonnull
    @CheckReturnValue
    public Rational abs() {
        return this._numerator < 0L ? this.negate() : this;
    }

    @Nonnull
    @CheckReturnValue
    public Rational add(long integer) {
        return this.add(Rational.valueOf(integer, 1L));
    }

    @Nonnull
    @CheckReturnValue
    public Rational add(@Nonnull Rational other) {
        Rational sum = this._denominator == other._denominator ? Rational.valueOf(this._numerator + other._numerator, this._denominator) : (this._numerator + other._numerator < Integer.MAX_VALUE && this._denominator + other._denominator < Integer.MAX_VALUE ? Rational.valueOf(this._numerator * other._denominator + other._numerator * this._denominator, this._denominator * other._denominator) : Rational.valueOf(BigInteger.valueOf(this._numerator).multiply(BigInteger.valueOf(other._denominator)).add(BigInteger.valueOf(other._numerator).multiply(BigInteger.valueOf(this._denominator))).longValue(), BigInteger.valueOf(this._denominator).multiply(BigInteger.valueOf(other._denominator)).longValue()));
        return sum;
    }

    @Override
    public int compareTo(Rational other) {
        return Long.compare(this._numerator * other._denominator, this._denominator * other._numerator);
    }

    @Nonnull
    @CheckReturnValue
    public Rational divide(long integer) {
        return Rational.valueOf(this._numerator, this._denominator * integer);
    }

    @Nonnull
    @CheckReturnValue
    public Rational divide(@Nonnull Rational other) {
        return this.multiply(other.reciprocal());
    }

    @Override
    public double doubleValue() {
        return (double)this._numerator / (double)this._denominator;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Rational) {
            Rational other = (Rational)object;
            return this._numerator == other._numerator && this._denominator == other._denominator;
        }
        return false;
    }

    @Override
    public float floatValue() {
        return (float)this._numerator / (float)this._denominator;
    }

    @CheckReturnValue
    public long getDenominator() {
        return this._denominator;
    }

    @CheckReturnValue
    public long getNumerator() {
        return this._numerator;
    }

    public int hashCode() {
        long bits = this._numerator ^ this._denominator;
        return (int)(bits ^ bits >>> 32);
    }

    @Override
    public int intValue() {
        return (int)(this._numerator / this._denominator);
    }

    @Override
    public long longValue() {
        return this._numerator / this._denominator;
    }

    @Nonnull
    @CheckReturnValue
    public Rational multiply(long integer) {
        return Rational.valueOf(this._numerator * integer, this._denominator);
    }

    @Nonnull
    @CheckReturnValue
    public Rational multiply(@Nonnull Rational other) {
        Rational product;
        if (this._numerator + other._numerator < Integer.MAX_VALUE && this._denominator + other._denominator < Integer.MAX_VALUE) {
            product = Rational.valueOf(this._numerator * other._numerator, this._denominator * other._denominator);
        } else {
            BigRational bigProduct = BigRational.valueOf(this).multiply(BigRational.valueOf(other));
            product = Rational.valueOf(bigProduct.getNumerator().longValue(), bigProduct.getDenominator().longValue());
        }
        return product;
    }

    @Nonnull
    @CheckReturnValue
    public Rational negate() {
        if (this._numerator == Long.MIN_VALUE) {
            throw new ArithmeticException();
        }
        return Rational.valueOf(-this._numerator, this._denominator);
    }

    @Nonnull
    @CheckReturnValue
    public Rational reciprocal() {
        return Rational.valueOf(this._denominator, this._numerator);
    }

    @CheckReturnValue
    public int signum() {
        return Long.signum(this._numerator);
    }

    @Nonnull
    @CheckReturnValue
    public Rational subtract(long integer) {
        return this.add(Rational.valueOf(-integer, 1L));
    }

    @Nonnull
    @CheckReturnValue
    public Rational subtract(@Nonnull Rational other) {
        return this.add(other.negate());
    }

    public String toString() {
        return Long.toString(this._numerator) + '/' + Long.toString(this._denominator);
    }

    private static long _gcd(long m, long n) {
        long r;
        if (m < 0L) {
            m = -m;
        }
        while ((r = m % n) != 0L) {
            m = n;
            n = r;
        }
        return n;
    }
}

