/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.value;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.VersionedValue;

@NotThreadSafe
public final class ReplicatedValue
extends VersionedValue {
    public static final String DELETED_FIELD = "deleted";
    private static final long serialVersionUID = 1L;
    private boolean _deleted;

    public ReplicatedValue() {
    }

    public ReplicatedValue(@Nonnull PointValue pointValue) {
        super(pointValue);
        this._deleted = pointValue.isDeleted();
    }

    @Override
    public ReplicatedValue copy() {
        return new ReplicatedValue(this);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean isDeleted() {
        return this._deleted;
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException {
        super.readExternal(input);
        this._deleted = input.readBoolean();
    }

    @Override
    public void readMap(Map<String, Serializable> map) {
        super.readMap(map);
        this._deleted = Boolean.parseBoolean((String)((Object)map.get(DELETED_FIELD)));
    }

    public void setDeleted(boolean deleted) {
        this.checkNotFrozen();
        this._deleted = deleted;
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        super.writeExternal(output);
        output.writeBoolean(this._deleted);
    }

    @Override
    public void writeMap(Map<String, Serializable> map) {
        if (this._deleted) {
            map.put("", null);
            map.put(DELETED_FIELD, (Serializable)((Object)Boolean.toString(this._deleted)));
        }
        super.writeMap(map);
    }
}

