/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.value;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.DateTime;
import org.rvpf.base.Point;
import org.rvpf.base.UUID;
import org.rvpf.base.value.PointValue;

@NotThreadSafe
public class ResultValue
extends PointValue {
    private static final long serialVersionUID = 1L;
    private transient boolean _fetched;
    private transient List<PointValue> _inputValues = new LinkedList<PointValue>();

    public ResultValue() {
    }

    public ResultValue(@Nonnull Point point, @Nonnull Optional<DateTime> stamp) {
        super(point, stamp, null, null);
    }

    protected ResultValue(@Nonnull ResultValue other) {
        super(other);
        this._inputValues.addAll(other._inputValues);
        this._fetched = other._fetched;
    }

    public final void addInputValue(@Nonnull PointValue inputValue) {
        if (inputValue.isAbsent() && !(inputValue instanceof PointValue.Null)) {
            inputValue = new PointValue.Null(inputValue);
        }
        this._inputValues.add(inputValue);
    }

    @Override
    public ResultValue copy() {
        return new ResultValue(this);
    }

    @Nonnull
    @CheckReturnValue
    public final List<PointValue> getInputValues() {
        return this._inputValues;
    }

    @CheckReturnValue
    public final boolean isFetched() {
        return this._fetched;
    }

    @CheckReturnValue
    public boolean isReplaceable() {
        return true;
    }

    @Override
    public ResultValue morph(Optional<UUID> uuid) {
        ResultValue clone = (ResultValue)super.morph(uuid);
        if (!uuid.isPresent()) {
            clone._inputValues = new ArrayList<PointValue>(this.getInputValues().size());
            for (PointValue inputValue : this.getInputValues()) {
                clone.addInputValue(inputValue.morph(Optional.empty()));
            }
        }
        return this;
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException {
        super.readExternal(input);
        int inputs = input.readInt();
        for (int i = 0; i < inputs; ++i) {
            PointValue inputValue = new PointValue();
            inputValue.readExternal(input);
            this._inputValues.add(inputValue);
        }
    }

    public final void setFetched(boolean fetched) {
        this._fetched = fetched;
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        super.writeExternal(output);
        output.writeInt(this._inputValues.size());
        for (PointValue inputValue : this._inputValues) {
            inputValue.writeExternal(output);
        }
    }
}

