/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.value;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Logger;

public final class State
extends Number
implements Externalizable {
    private Optional<Integer> _code;
    private Optional<String> _name;

    public State() {
        this._code = Optional.empty();
        this._name = Optional.empty();
    }

    public State(@Nonnull Optional<Integer> code, @Nonnull Optional<String> name) {
        this._code = code;
        this._name = name;
    }

    @Nonnull
    @CheckReturnValue
    public static State fromString(String string) {
        Integer code;
        String codeString;
        int split = (string = string.trim()).indexOf(58);
        String string2 = split < 0 ? string : (codeString = split > 0 ? string.substring(0, split) : null);
        if (codeString != null) {
            try {
                code = Integer.valueOf(codeString);
            }
            catch (NumberFormatException exceptione) {
                code = null;
            }
        } else {
            code = null;
            string = string.substring(1);
        }
        String name = code == null ? string : (split >= 0 ? string.substring(split + 1) : "");
        return new State(Optional.ofNullable(code), name.length() > 0 ? Optional.of(name) : Optional.empty());
    }

    @Override
    public double doubleValue() {
        return this._code.isPresent() ? this._code.get().doubleValue() : 0.0;
    }

    public boolean equals(Object other) {
        if (other instanceof State) {
            if (this._code.isPresent()) {
                return this._code.equals(((State)other)._code);
            }
            if (this._name.isPresent()) {
                return this._name.equals(((State)other)._name);
            }
            return !((State)other)._code.isPresent() && !((State)other)._name.isPresent();
        }
        return false;
    }

    @Override
    public float floatValue() {
        return this._code.isPresent() ? this._code.get().floatValue() : 0.0f;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Integer> getCode() {
        return this._code;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<String> getName() {
        return this._name;
    }

    public int hashCode() {
        return this._code.isPresent() ? this._code.get().hashCode() : (this._name.isPresent() ? this._name.get().hashCode() : 0);
    }

    @Override
    public int intValue() {
        return this._code.isPresent() ? this._code.get() : 0;
    }

    @Override
    public long longValue() {
        return this._code.isPresent() ? this._code.get().longValue() : 0L;
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException {
        State state = State.fromString(input.readUTF());
        this._code = state.getCode();
        this._name = state.getName();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this._code.isPresent()) {
            stringBuilder.append(this._code.get());
        }
        stringBuilder.append(':');
        if (this._name.isPresent()) {
            stringBuilder.append(this._name.get());
        }
        return stringBuilder.toString();
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        output.writeUTF(this.toString());
    }

    public static final class Group
    implements Externalizable {
        private String _name;
        private final Map<Integer, State> _statesByCode = new TreeMap<Integer, State>();
        private final Map<String, State> _statesByName = new TreeMap<String, State>();

        public Group() {
        }

        public Group(@Nonnull String name) {
            this._name = name;
        }

        @Nonnull
        @CheckReturnValue
        public Optional<State> get(int code) {
            return this.get((Integer)code);
        }

        @Nonnull
        @CheckReturnValue
        public Optional<State> get(@Nonnull Integer code) {
            return Optional.ofNullable(this._statesByCode.get(code));
        }

        @Nonnull
        @CheckReturnValue
        public Optional<State> get(@Nonnull String name) {
            return Optional.ofNullable(this._statesByName.get(name.trim().toUpperCase(Locale.ROOT)));
        }

        @Nonnull
        @CheckReturnValue
        public String getName() {
            return this._name;
        }

        @Nonnull
        @CheckReturnValue
        public List<State> getStatesByCode() {
            return new ArrayList<State>(this._statesByCode.values());
        }

        @Nonnull
        @CheckReturnValue
        public List<State> getStatesByName() {
            return new ArrayList<State>(this._statesByName.values());
        }

        public void put(@Nonnull State state) {
            if (state.getName().isPresent() && this._statesByName.put(state.getName().get().trim().toUpperCase(Locale.ROOT), state) != null) {
                Logger.getInstance(this.getClass()).warn(BaseMessages.DUPLICATE_STATE_NAME, state.getName().get(), this.getName());
            }
            if (state.getCode().isPresent() && this._statesByCode.put(state.getCode().get(), state) != null) {
                Logger.getInstance(this.getClass()).warn(BaseMessages.DUPLICATE_STATE_CODE, state.getCode().get(), this.getName());
            }
        }

        @Override
        public void readExternal(ObjectInput input) throws IOException {
            this._name = input.readUTF();
            for (int count = input.readInt(); count > 0; --count) {
                this.put(State.fromString(input.readUTF()));
            }
        }

        @CheckReturnValue
        public int size() {
            return this._statesByName.size();
        }

        @Override
        public void writeExternal(ObjectOutput output) throws IOException {
            output.writeUTF(this._name);
            output.writeInt(this._statesByName.size());
            for (State state : this._statesByName.values()) {
                output.writeUTF(state.toString());
            }
        }
    }
}

