/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.value;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import org.rvpf.base.value.Container;

public final class Tuple
implements Container,
List<Serializable> {
    private static final long serialVersionUID = 1L;
    private transient List<Serializable> _frozen;
    private ArrayList<Serializable> _items;

    public Tuple() {
        this(0);
    }

    public Tuple(@Nonnull Collection<? extends Serializable> contents) {
        this._items = new ArrayList<Serializable>(contents);
    }

    public Tuple(int capacity) {
        this._items = new ArrayList(capacity);
    }

    public Tuple(@Nonnull Serializable[] contents) {
        this(contents.length);
        for (Serializable content : contents) {
            this.add(content);
        }
    }

    @Override
    public boolean add(Serializable item) {
        return this._getItems().add(item);
    }

    @Override
    public void add(int index, Serializable item) {
        this._getItems().add(index, item);
    }

    @Override
    public boolean addAll(Collection<? extends Serializable> collection) {
        return this._getItems().addAll(collection);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Serializable> collection) {
        return this._getItems().addAll(index, collection);
    }

    @Override
    public void clear() {
        this._getItems().clear();
    }

    public Tuple clone() {
        Tuple clone;
        try {
            clone = (Tuple)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError(exception);
        }
        clone._items = (ArrayList)this._items.clone();
        clone._frozen = null;
        return clone;
    }

    @Override
    public boolean contains(Object object) {
        return this._items.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this._items.containsAll(collection);
    }

    public void ensureCapacity(int capacity) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException();
        }
        this._items.ensureCapacity(capacity);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Tuple)) {
            return false;
        }
        return this._items.equals(((Tuple)object)._items);
    }

    @Override
    public void freeze() {
        if (this._frozen == null) {
            this._frozen = Collections.unmodifiableList(this._items);
        }
    }

    @Override
    public Serializable get(int index) {
        return this._items.get(index);
    }

    @Override
    public int hashCode() {
        return this._items.hashCode();
    }

    @Override
    public int indexOf(Object object) {
        return this._items.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this._items.isEmpty();
    }

    @Override
    public boolean isFrozen() {
        return this._frozen != null;
    }

    @Override
    public Iterator<Serializable> iterator() {
        return this._getItems().iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this._items.lastIndexOf(object);
    }

    @Override
    public ListIterator<Serializable> listIterator() {
        return this._getItems().listIterator();
    }

    @Override
    public ListIterator<Serializable> listIterator(int index) {
        return this._getItems().listIterator(index);
    }

    @Override
    public Serializable remove(int index) {
        return this._getItems().remove(index);
    }

    @Override
    public boolean remove(Object object) {
        return this._getItems().remove(object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this._getItems().removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this._getItems().retainAll(collection);
    }

    @Override
    public Serializable set(int index, Serializable item) {
        return this._getItems().set(index, item);
    }

    @Override
    public int size() {
        return this._items.size();
    }

    @Override
    public List<Serializable> subList(int fromIndex, int toIndex) {
        return this._getItems().subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this._items.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this._items.toArray(array);
    }

    public String toString() {
        return this._items.toString();
    }

    private List<Serializable> _getItems() {
        List<Serializable> frozen = this._frozen;
        return frozen != null ? frozen : this._items;
    }

    private Object readResolve() {
        this.freeze();
        return this;
    }
}

