/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.value;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.DateTime;
import org.rvpf.base.UUID;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;

@NotThreadSafe
public class VersionedValue
extends PointValue {
    public static final String VERSION_FIELD = "version";
    private static final long serialVersionUID = 1L;
    private static final AtomicLong _reference = new AtomicLong();
    private DateTime _version;

    public VersionedValue() {
    }

    public VersionedValue(PointValue pointValue) {
        super(pointValue);
        this._version = VersionedValue.newVersion();
    }

    public VersionedValue(@Nonnull UUID uuid, @Nonnull Optional<DateTime> stamp, @Nonnull DateTime version, @Nullable Serializable state, @Nullable Serializable value) {
        super(uuid, stamp, state, value);
        this._version = Require.notNull(version);
    }

    protected VersionedValue(@Nonnull String point, @Nonnull Optional<DateTime> stamp) {
        super(point, stamp, null, null);
        this._version = VersionedValue.newVersion();
    }

    protected VersionedValue(@Nonnull UUID uuid, @Nonnull Optional<DateTime> stamp) {
        super(uuid, stamp, null, null);
        this._version = VersionedValue.newVersion();
    }

    @Nonnull
    @CheckReturnValue
    public static DateTime newVersion() {
        long reference;
        DateTime now = DateTime.now();
        long version = now.toRaw();
        do {
            if (version > (reference = _reference.get())) continue;
            version = reference + 10L;
        } while (!_reference.compareAndSet(reference, version));
        return version == now.toRaw() ? now : DateTime.fromRaw(version);
    }

    @Override
    public VersionedValue copy() {
        return new VersionedValue(this);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public VersionedValue frozen() {
        VersionedValue frozen;
        if (this.isFrozen()) {
            frozen = this;
        } else {
            frozen = this.copy();
            frozen.freeze();
        }
        return frozen;
    }

    @Override
    public DateTime getVersion() {
        return this._version;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException {
        super.readExternal(input);
        DateTime version = DateTime.readExternal(input).get();
        this._version = version != null ? version : VersionedValue.newVersion();
    }

    @Override
    public void readMap(Map<String, Serializable> map) {
        super.readMap(map);
        String versionString = (String)((Object)map.get(VERSION_FIELD));
        this._version = DateTime.fromString(Optional.ofNullable(versionString)).orElse(VersionedValue.newVersion());
    }

    @Override
    public VersionedValue thawed() {
        return this.isFrozen() ? this.copy() : this;
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        super.writeExternal(output);
        DateTime.writeExternal(Optional.ofNullable(this._version), output);
    }

    @Override
    public void writeMap(Map<String, Serializable> map) {
        map.put("", null);
        map.put(VERSION_FIELD, (Serializable)((Object)this._version.toString()));
        super.writeMap(map);
    }

    @Override
    protected String getStampString(DateTime.Context dateTimeContext) {
        return super.getStampString(dateTimeContext) + "/" + dateTimeContext.toString(this._version);
    }

    @Override
    protected void setVersion(DateTime version) {
        this._version = version;
    }

    @NotThreadSafe
    public static final class Purged
    extends VersionedValue {
        private static final long serialVersionUID = 1L;

        public Purged() {
        }

        public Purged(@Nonnull PointValue pointValue) {
            super(pointValue);
        }

        public Purged(@Nonnull String point, @Nonnull Optional<DateTime> stamp) {
            super(point, stamp);
        }

        public Purged(@Nonnull UUID uuid, @Nonnull Optional<DateTime> stamp) {
            super(uuid, stamp);
        }

        @Override
        public Purged copy() {
            return new Purged(this);
        }

        @Override
        public boolean isDeleted() {
            return true;
        }
    }

    public static final class Factory {
        private Factory() {
        }

        @Nonnull
        @CheckReturnValue
        public static VersionedValue restore(@Nonnull UUID uuid, @Nonnull Optional<DateTime> stamp, @Nonnull DateTime version, @Nullable Serializable state, @Nullable Serializable value) {
            VersionedValue restoredValue = uuid.isDeleted() ? new Deleted(uuid.undeleted(), stamp, version) : new VersionedValue(uuid, stamp, version, state, value);
            restoredValue.freeze();
            return restoredValue;
        }
    }

    @NotThreadSafe
    public static final class Deleted
    extends VersionedValue {
        private static final long serialVersionUID = 1L;

        public Deleted() {
        }

        public Deleted(@Nonnull PointValue pointValue) {
            super(pointValue);
        }

        public Deleted(@Nonnull String point, @Nonnull Optional<DateTime> stamp) {
            super(point, stamp);
        }

        public Deleted(@Nonnull UUID uuid, @Nonnull Optional<DateTime> stamp) {
            super(uuid, stamp);
        }

        Deleted(@Nonnull UUID uuid, @Nonnull Optional<DateTime> stamp, @Nonnull DateTime version) {
            super(uuid, stamp, version, null, null);
        }

        @Override
        public Deleted copy() {
            return new Deleted(this);
        }

        @Override
        public boolean isDeleted() {
            return true;
        }
    }
}

