/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.value.filter;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.filter.ValueFilter;

public class DeadbandFilter
extends ValueFilter.Abstract {
    private final double _deadbandGap;
    private final double _deadbandRatio;

    public DeadbandFilter(@Nonnull Optional<ElapsedTime> timeLimit, @Nonnull Optional<ElapsedTime> stampTrimUnit, double deadbangGap, double deadbandRatio) {
        super(timeLimit, stampTrimUnit);
        this._deadbandGap = deadbangGap;
        this._deadbandRatio = deadbandRatio;
        this.setDisabled(this._deadbandGap < 0.0 && this._deadbandRatio < 0.0);
    }

    @Override
    protected Optional<PointValue> doFilter(PointValue pointValue) {
        if (this.shouldFilter(pointValue.toDouble(), this.getPreviousPointValue().get().toDouble())) {
            return Optional.empty();
        }
        this.setPreviousPointValue(pointValue);
        return Optional.of(pointValue);
    }

    @CheckReturnValue
    protected boolean shouldFilter(@Nonnull Double value, @Nonnull Double referenceValue) {
        double deadbandSize = this._deadbandGap;
        if (deadbandSize < 0.0) {
            if (this._deadbandRatio < 0.0) {
                return false;
            }
            deadbandSize = Math.abs(referenceValue) * this._deadbandRatio;
        }
        return Math.abs(value - referenceValue) <= deadbandSize;
    }
}

