/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.value.filter;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.filter.DeadbandFilter;

public class InterpolatorFilter
extends DeadbandFilter {
    public InterpolatorFilter(@Nonnull Optional<ElapsedTime> timeLimit, @Nonnull Optional<ElapsedTime> stampTrimUnit, double deadbangGap, double deadbandRatio) {
        super(timeLimit, stampTrimUnit, deadbangGap, deadbandRatio);
    }

    @Nonnull
    @CheckReturnValue
    protected static Double polate(@Nonnull DateTime stamp, @Nonnull PointValue pointValue1, @Nonnull PointValue pointValue2) {
        long x1 = pointValue1.getStamp().toRaw();
        long x2 = pointValue2.getStamp().toRaw();
        long x = stamp.toRaw();
        double y1 = pointValue1.toDouble();
        double y2 = pointValue2.toDouble();
        double y = y1 + (y2 - y1) * (double)(x - x1) / (double)(x2 - x1);
        return y;
    }

    @Override
    protected Optional<PointValue> doFilter(PointValue pointValue) {
        Optional<PointValue> filtered;
        Optional<PointValue> previousPointValue = this.getPreviousPointValue();
        Optional<PointValue> heldPointValue = this.getHeldPointValue();
        if (!heldPointValue.isPresent()) {
            this.setHeldPointValue(pointValue);
            return Optional.empty();
        }
        Double interpolated = InterpolatorFilter.polate(heldPointValue.get().getStamp(), previousPointValue.get(), pointValue);
        if (this.shouldFilter(heldPointValue.get().toDouble(), interpolated)) {
            filtered = Optional.empty();
        } else {
            this.setPreviousPointValue(heldPointValue.get());
            filtered = heldPointValue;
        }
        this.setHeldPointValue(pointValue);
        return filtered;
    }
}

