/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.value.filter;

import java.util.Optional;
import javax.annotation.Nonnull;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.filter.InterpolatorFilter;

public class LinearFilter
extends InterpolatorFilter {
    private Optional<PointValue> _firstPointValue = Optional.empty();

    public LinearFilter(@Nonnull Optional<ElapsedTime> timeLimit, @Nonnull Optional<ElapsedTime> stampTrimUnit, double deadbangGap, double deadbandRatio) {
        super(timeLimit, stampTrimUnit, deadbangGap, deadbandRatio);
    }

    @Override
    public void reset() {
        this._firstPointValue = Optional.empty();
        super.reset();
    }

    @Override
    protected Optional<PointValue> doFilter(PointValue pointValue) {
        if (!this._firstPointValue.isPresent()) {
            this._firstPointValue = this.getPreviousPointValue();
            this.setPreviousPointValue(pointValue);
            return Optional.of(pointValue);
        }
        Optional<PointValue> previousPointValue = this.getPreviousPointValue();
        Optional<PointValue> heldPointValue = this.getHeldPointValue();
        if (!super.doFilter(pointValue).isPresent()) {
            if (!heldPointValue.isPresent()) {
                return Optional.empty();
            }
            Double extrapolated = LinearFilter.polate(pointValue.getStamp(), this._firstPointValue.get(), this.getPreviousPointValue().get());
            if (this.shouldFilter(pointValue.toDouble(), extrapolated)) {
                pointValue = null;
            } else {
                this._firstPointValue = this.getPreviousPointValue();
                this.setPreviousPointValue(heldPointValue.get());
                pointValue = heldPointValue.get();
            }
        } else {
            this._firstPointValue = previousPointValue;
        }
        return Optional.ofNullable(pointValue);
    }
}

