/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.value.filter;

import java.util.Optional;
import javax.annotation.Nonnull;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.filter.DeadbandFilter;

public final class StepFilter
extends DeadbandFilter {
    private final double _ceilingGap;
    private final double _floorGap;
    private final double _stepSize;

    public StepFilter(@Nonnull Optional<ElapsedTime> timeLimit, @Nonnull Optional<ElapsedTime> trimUnit, double deadbangGap, double deadbandRatio, double stepSize, double ceilingGap, double floorGap) {
        super(timeLimit, trimUnit, deadbangGap, deadbandRatio);
        this._stepSize = stepSize;
        this.setDisabled(this.isDisabled() && this._stepSize <= 0.0);
        if (!this.isDisabled()) {
            if (ceilingGap < 0.0) {
                ceilingGap = this._stepSize / 2.0;
            }
            if (floorGap < 0.0) {
                floorGap = this._stepSize / 2.0;
            }
        }
        this._ceilingGap = ceilingGap;
        this._floorGap = floorGap;
    }

    @Override
    protected PointValue snap(PointValue pointValue) {
        if (this._stepSize > 0.0) {
            double step;
            Double value = pointValue.toDouble();
            if (value == null) {
                return pointValue;
            }
            double scaled = value / this._stepSize;
            double gap = scaled - (step = Math.floor(scaled));
            if (gap <= this._floorGap) {
                return this._snap(pointValue, step);
            }
            step = Math.ceil(scaled);
            gap = step - scaled;
            if (gap <= this._ceilingGap) {
                return this._snap(pointValue, step);
            }
        }
        return pointValue;
    }

    private PointValue _snap(@Nonnull PointValue pointValue, double step) {
        pointValue = pointValue.thawed();
        pointValue.setValue(Double.valueOf(step * this._stepSize));
        return pointValue;
    }
}

