/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.value.filter;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.value.PointValue;

public interface ValueFilter {
    @Nonnull
    @CheckReturnValue
    public PointValue[] filter(@Nonnull Optional<PointValue> var1);

    @CheckReturnValue
    public boolean isDisabled();

    public void reset();

    public static abstract class Abstract
    implements ValueFilter {
        protected static final PointValue[] NO_POINT_VALUES = new PointValue[0];
        private boolean _disabled;
        private Optional<PointValue> _heldPointValue = Optional.empty();
        private Optional<PointValue> _previousPointValue = Optional.empty();
        private final Optional<ElapsedTime> _stampTrimUnit;
        private final Optional<ElapsedTime> _timeLimit;

        protected Abstract(@Nonnull Optional<ElapsedTime> timeLimit, @Nonnull Optional<ElapsedTime> stampTrimUnit) {
            this._timeLimit = timeLimit;
            this._stampTrimUnit = stampTrimUnit;
        }

        @Override
        public final PointValue[] filter(Optional<PointValue> optionalPointValue) {
            DateTime stamp;
            DateTime trimmedStamp;
            if (this.isDisabled()) {
                return this.pointValues(optionalPointValue.orElse(null));
            }
            if (!optionalPointValue.isPresent()) {
                Optional<PointValue> heldPointValue = this.getHeldPointValue();
                this.reset();
                return this.pointValues(heldPointValue.orElse(null));
            }
            PointValue pointValue = optionalPointValue.get();
            if (!pointValue.hasStamp()) {
                pointValue = pointValue.thawed();
                pointValue.setStamp(DateTime.now());
            }
            if (this._stampTrimUnit.isPresent() && !(trimmedStamp = (stamp = pointValue.getStamp()).floored(this._stampTrimUnit.get())).equals(stamp)) {
                pointValue = pointValue.thawed();
                pointValue.clearStamp();
                pointValue.setStamp(trimmedStamp);
            }
            if (pointValue.getValue() == null) {
                Optional<PointValue> heldPointValue = this.getHeldPointValue();
                this.reset();
                return heldPointValue.isPresent() ? this.pointValues(heldPointValue.get(), pointValue) : this.pointValues(pointValue);
            }
            pointValue = this.snap(pointValue);
            Optional<PointValue> previousPointValue = this.getPreviousPointValue();
            if (!previousPointValue.isPresent()) {
                this.setPreviousPointValue(pointValue);
                return this.pointValues(pointValue);
            }
            Optional<ElapsedTime> timeLimit = this.getTimeLimit();
            if (timeLimit.isPresent() && timeLimit.get().compareTo(pointValue.getStamp().sub(previousPointValue.get().getStamp())) < 0) {
                Optional<PointValue> heldPointValue = this.getHeldPointValue();
                this.reset();
                this.setPreviousPointValue(pointValue);
                return heldPointValue.isPresent() ? this.pointValues(heldPointValue.get(), pointValue) : this.pointValues(pointValue);
            }
            if (pointValue != null && (pointValue = (PointValue)this.doFilter(pointValue).orElse(null)) != null) {
                pointValue.freeze();
            }
            return this.pointValues(pointValue);
        }

        @Override
        public final boolean isDisabled() {
            return this._disabled;
        }

        @Override
        public void reset() {
            this._previousPointValue = Optional.empty();
            this._heldPointValue = Optional.empty();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this));
        }

        @Nonnull
        @CheckReturnValue
        protected abstract Optional<PointValue> doFilter(@Nonnull PointValue var1);

        @Nonnull
        @CheckReturnValue
        protected final Optional<PointValue> getHeldPointValue() {
            return this._heldPointValue;
        }

        @Nonnull
        @CheckReturnValue
        protected final Optional<PointValue> getPreviousPointValue() {
            return this._previousPointValue;
        }

        @Nonnull
        @CheckReturnValue
        protected final Optional<ElapsedTime> getTimeLimit() {
            return this._timeLimit;
        }

        @Nonnull
        @CheckReturnValue
        protected PointValue[] pointValues(PointValue ... pointValues) {
            return pointValues.length == 1 && pointValues[0] == null ? NO_POINT_VALUES : pointValues;
        }

        protected final void setDisabled(boolean disabled) {
            this._disabled = disabled;
        }

        protected final void setHeldPointValue(@Nonnull PointValue heldPointValue) {
            this._heldPointValue = Optional.of(heldPointValue.frozen());
        }

        protected final void setPreviousPointValue(@Nonnull PointValue previousValue) {
            this._previousPointValue = Optional.of(previousValue.frozen());
        }

        @Nonnull
        @CheckReturnValue
        protected PointValue snap(@Nonnull PointValue pointValue) {
            return pointValue;
        }
    }
}

